/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption.signers;

import dev.sigstore.AlgorithmRegistry;
import dev.sigstore.encryption.signers.EcdsaSigner;
import dev.sigstore.encryption.signers.RsaSigner;
import dev.sigstore.encryption.signers.Signer;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.ECGenParameterSpec;

public class Signers {
    public static Signer from(AlgorithmRegistry.SigningAlgorithm algorithm) {
        switch (algorithm) {
            case PKIX_RSA_PKCS1V15_2048_SHA256: {
                return Signers.newRsaSigner(2048, AlgorithmRegistry.HashAlgorithm.SHA2_256);
            }
            case PKIX_RSA_PKCS1V15_3072_SHA256: {
                return Signers.newRsaSigner(3072, AlgorithmRegistry.HashAlgorithm.SHA2_256);
            }
            case PKIX_RSA_PKCS1V15_4096_SHA256: {
                return Signers.newRsaSigner(4096, AlgorithmRegistry.HashAlgorithm.SHA2_256);
            }
            case PKIX_ECDSA_P256_SHA_256: {
                return Signers.newEcdsaSigner("secp256r1", AlgorithmRegistry.HashAlgorithm.SHA2_256);
            }
        }
        throw new IllegalStateException("Unknown algorithm: " + String.valueOf((Object)algorithm));
    }

    static EcdsaSigner newEcdsaSigner(String spec, AlgorithmRegistry.HashAlgorithm hashAlgorithm) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
            keyGen.initialize(new ECGenParameterSpec(spec));
            return new EcdsaSigner(keyGen.generateKeyPair(), hashAlgorithm);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException nse) {
            throw new RuntimeException("No EC algorithm found in Runtime", nse);
        }
    }

    static RsaSigner newRsaSigner(int keysize, AlgorithmRegistry.HashAlgorithm hashAlgorithm) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(keysize);
            return new RsaSigner(keyGen.generateKeyPair(), hashAlgorithm);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new RuntimeException("No RSA algorithm found in Runtime", nse);
        }
    }
}

