/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.encryption.signers;

import dev.sigstore.encryption.signers.EcdsaVerifier;
import dev.sigstore.encryption.signers.Ed25519Verifier;
import dev.sigstore.encryption.signers.RsaVerifier;
import dev.sigstore.encryption.signers.Verifier;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class Verifiers {
    public static Verifier newVerifier(PublicKey publicKey) throws NoSuchAlgorithmException {
        if (publicKey.getAlgorithm().equals("RSA")) {
            return new RsaVerifier(publicKey);
        }
        if (publicKey.getAlgorithm().equals("EC") || publicKey.getAlgorithm().equals("ECDSA")) {
            return new EcdsaVerifier(publicKey);
        }
        if (publicKey.getAlgorithm().equals("Ed25519")) {
            return new Ed25519Verifier(publicKey);
        }
        if (publicKey.getAlgorithm().equals("EdDSA")) {
            SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            if (spki.getAlgorithm() != null && new ASN1ObjectIdentifier("1.3.101.112").equals((ASN1Primitive)spki.getAlgorithm().getAlgorithm())) {
                return new Ed25519Verifier(publicKey);
            }
            throw new NoSuchAlgorithmException("Cannot verify signatures for non-Ed25519 EdDSA key types, this client only supports RSA, ECDSA, and Ed25519 verification");
        }
        throw new NoSuchAlgorithmException("Cannot verify signatures for key type '" + publicKey.getAlgorithm() + "', this client only supports RSA, ECDSA, and Ed25519 verification");
    }
}

