/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.fulcio.client;

import dev.sigstore.VerificationOptions;
import dev.sigstore.strings.StringMatcher;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.encoders.Hex;
import org.immutables.value.Value;

@Value.Immutable
public abstract class FulcioCertificateMatcher
implements VerificationOptions.CertificateMatcher {
    private static final Logger log = Logger.getLogger(FulcioCertificateMatcher.class.getName());
    private static final String FULCIO_ISSUER_OLD_OID = "1.3.6.1.4.1.57264.1.1";
    private static final String FULCIO_ISSUER_OID = "1.3.6.1.4.1.57264.1.8";

    public abstract StringMatcher getIssuer();

    public abstract StringMatcher getSubjectAlternativeName();

    public abstract Map<String, StringMatcher> getOidRawStrings();

    public abstract Map<String, StringMatcher> getOidDerAsn1Strings();

    public abstract Map<String, byte[]> getOidBytes();

    private static void logMismatch(String oid, String expected, String actual) {
        log.fine(oid + " value did not match - expected:" + expected + ", actual:" + actual);
    }

    public String toString() {
        String str = "{issuer:" + String.valueOf(this.getIssuer()) + ",san:" + String.valueOf(this.getSubjectAlternativeName());
        if (!this.getOidRawStrings().isEmpty()) {
            str = str + ",oidRawStrings:{" + this.getOidRawStrings().entrySet().stream().map(e -> (String)e.getKey() + ":" + String.valueOf(e.getValue())).collect(Collectors.joining(",")) + "}";
        }
        if (!this.getOidDerAsn1Strings().isEmpty()) {
            str = str + ",oidDerAsn1Strings:{" + this.getOidDerAsn1Strings().entrySet().stream().map(e -> (String)e.getKey() + ":" + String.valueOf(e.getValue())).collect(Collectors.joining(",")) + "}";
        }
        if (!this.getOidBytes().isEmpty()) {
            str = str + ",oidBytes:{" + this.getOidBytes().entrySet().stream().map(e -> (String)e.getKey() + ":" + this.hexOrNull((byte[])e.getValue())).collect(Collectors.joining(",")) + "}";
        }
        return str + "}";
    }

    @Override
    public boolean test(X509Certificate certificate) throws VerificationOptions.UncheckedCertificateException {
        try {
            Object expected;
            Object entry;
            String san = this.extractSan(certificate);
            if (!this.getSubjectAlternativeName().test(san)) {
                FulcioCertificateMatcher.logMismatch("san", this.getSubjectAlternativeName().toString(), san);
                return false;
            }
            String issuer = this.extractIssuer(certificate);
            if (!this.getIssuer().test(issuer)) {
                FulcioCertificateMatcher.logMismatch("issuer", this.getIssuer().toString(), issuer);
                return false;
            }
            for (String rawOid : this.getOidRawStrings().keySet()) {
                entry = this.getExtensionValueRawUtf8(certificate, rawOid);
                expected = this.getOidRawStrings().get(rawOid);
                if (expected.test(entry)) continue;
                FulcioCertificateMatcher.logMismatch(rawOid, expected.toString(), (String)entry);
                return false;
            }
            for (String derOid : this.getOidDerAsn1Strings().keySet()) {
                entry = this.getExtensionValueDerAsn1Utf8(certificate, derOid);
                expected = this.getOidDerAsn1Strings().get(derOid);
                if (expected.test(entry)) continue;
                FulcioCertificateMatcher.logMismatch(derOid, expected.toString(), (String)entry);
                return false;
            }
            for (String bytesOid : this.getOidBytes().keySet()) {
                entry = certificate.getExtensionValue(bytesOid);
                if (Arrays.equals((byte[])entry, (byte[])(expected = (Object)this.getOidBytes().get(bytesOid)))) continue;
                FulcioCertificateMatcher.logMismatch(bytesOid, this.hexOrNull((byte[])expected), this.hexOrNull((byte[])entry));
                return false;
            }
            return true;
        }
        catch (CertificateException ce) {
            throw new VerificationOptions.UncheckedCertificateException("Failed to process certificate ", ce);
        }
    }

    private String extractSan(X509Certificate cert) throws CertificateParsingException {
        try {
            Collection<List<?>> sans = cert.getSubjectAlternativeNames();
            if (sans.size() == 0) {
                throw new CertificateParsingException("No SANs found in fulcio certificate");
            }
            if (sans.size() > 1) {
                throw new CertificateParsingException("Fulcio certificate must only have 1 SAN, but found " + sans.size());
            }
            List<?> san = sans.stream().findFirst().get();
            Integer type = (Integer)san.get(0);
            if (!type.equals(1) && !type.equals(6)) {
                throw new CertificateParsingException("Fulcio certificates SAN must be of type rfc822 or URI");
            }
            return (String)san.get(1);
        }
        catch (CertificateParsingException cpe) {
            throw new CertificateParsingException("Could not parse SAN from fulcio certificate", cpe);
        }
    }

    private String extractIssuer(X509Certificate cert) throws CertificateParsingException {
        String issuer = this.getExtensionValueDerAsn1Utf8(cert, FULCIO_ISSUER_OID);
        if (issuer == null) {
            issuer = this.getExtensionValueRawUtf8(cert, FULCIO_ISSUER_OLD_OID);
        }
        if (issuer == null) {
            throw new CertificateParsingException("No issuer found in fulcio certificate");
        }
        return issuer;
    }

    private String getExtensionValueRawUtf8(X509Certificate cert, String oid) throws CertificateParsingException {
        byte[] extensionValue = cert.getExtensionValue(oid);
        if (extensionValue == null) {
            return null;
        }
        try {
            ASN1Primitive derObject = ASN1Sequence.fromByteArray((byte[])cert.getExtensionValue(oid));
            if (derObject instanceof DEROctetString) {
                DEROctetString derOctetString = (DEROctetString)derObject;
                return new String(derOctetString.getOctets(), StandardCharsets.UTF_8);
            }
            throw new CertificateParsingException("Could not parse extension " + oid + " in certificate because it was not a properly formatted extension sequence");
        }
        catch (IOException ioe) {
            throw new CertificateParsingException("Could not parse extension " + oid + " in certificate", ioe);
        }
    }

    private String getExtensionValueDerAsn1Utf8(X509Certificate cert, String oid) throws CertificateParsingException {
        byte[] extensionValue = cert.getExtensionValue(oid);
        if (extensionValue == null) {
            return null;
        }
        try {
            ASN1Primitive derObject = ASN1Sequence.fromByteArray((byte[])cert.getExtensionValue(oid));
            if (derObject instanceof DEROctetString) {
                DEROctetString derOctetString = (DEROctetString)derObject;
                ASN1Primitive derString = ASN1Sequence.fromByteArray((byte[])derOctetString.getOctets());
                if (derString instanceof ASN1String) {
                    return ((ASN1String)derString).getString();
                }
                throw new CertificateParsingException("Could not parse extension " + oid + " in certificate because it was not a DER encoded ASN.1 string");
            }
            throw new CertificateParsingException("Could not parse extension " + oid + " in certificate because it was not a properly formatted extension sequence");
        }
        catch (IOException ioe) {
            throw new CertificateParsingException("Could not parse extension " + oid + " in certificate", ioe);
        }
    }

    private String hexOrNull(byte[] bytes) {
        if (bytes == null) {
            return "NULL";
        }
        return "'hex: " + Hex.toHexString((byte[])bytes) + "'";
    }
}

