/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.fulcio.client;

import com.google.api.client.util.Preconditions;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import dev.sigstore.fulcio.client.CertificateRequest;
import dev.sigstore.fulcio.client.FulcioClient;
import dev.sigstore.fulcio.v2.CAGrpc;
import dev.sigstore.fulcio.v2.CertificateChain;
import dev.sigstore.fulcio.v2.CreateSigningCertificateRequest;
import dev.sigstore.fulcio.v2.Credentials;
import dev.sigstore.fulcio.v2.PublicKey;
import dev.sigstore.fulcio.v2.PublicKeyRequest;
import dev.sigstore.fulcio.v2.SigningCertificate;
import dev.sigstore.http.GrpcChannels;
import dev.sigstore.http.HttpParams;
import dev.sigstore.trustroot.Service;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.TimeUnit;

public class FulcioClientGrpc
implements FulcioClient {
    private final HttpParams httpParams;
    private final URI uri;

    public static Builder builder() {
        return new Builder();
    }

    private FulcioClientGrpc(HttpParams httpParams, URI uri) {
        this.uri = uri;
        this.httpParams = httpParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CertPath signingCertificate(CertificateRequest request) throws InterruptedException, CertificateException {
        ManagedChannel channel = GrpcChannels.newManagedChannel(this.uri.getAuthority(), this.httpParams);
        try {
            CAGrpc.CABlockingStub client = CAGrpc.newBlockingStub((Channel)channel);
            Credentials credentials = Credentials.newBuilder().setOidcIdentityToken(request.getIdToken()).build();
            String pemEncodedPublicKey = "-----BEGIN PUBLIC KEY-----\n" + Base64.getEncoder().encodeToString(request.getPublicKey().getEncoded()) + "\n-----END PUBLIC KEY-----";
            PublicKeyRequest publicKeyRequest = PublicKeyRequest.newBuilder().setPublicKey(PublicKey.newBuilder().setAlgorithm(request.getPublicKeyAlgorithm()).setContent(pemEncodedPublicKey).build()).setProofOfPossession(ByteString.copyFrom((byte[])request.getProofOfPossession())).build();
            CreateSigningCertificateRequest req = CreateSigningCertificateRequest.newBuilder().setCredentials(credentials).setPublicKeyRequest(publicKeyRequest).build();
            SigningCertificate certs = ((CAGrpc.CABlockingStub)client.withDeadlineAfter(this.httpParams.getTimeout(), TimeUnit.SECONDS)).createSigningCertificate(req);
            if (certs.getCertificateCase() == SigningCertificate.CertificateCase.SIGNED_CERTIFICATE_DETACHED_SCT) {
                throw new CertificateException("Detached SCTs are not supported");
            }
            CertPath certPath = this.decodeCerts(certs.getSignedCertificateEmbeddedSct().getChain());
            return certPath;
        }
        finally {
            channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    @VisibleForTesting
    CertPath decodeCerts(CertificateChain certChain) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        if (certChain.getCertificatesCount() == 0) {
            throw new CertificateParsingException("no valid PEM certificates were found in response from Fulcio");
        }
        for (ByteString cert : certChain.getCertificatesList().asByteStringList()) {
            certs.add((X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(cert.toByteArray())));
        }
        return certificateFactory.generateCertPath(certs);
    }

    public static class Builder {
        private Service service;
        private HttpParams httpParams = HttpParams.builder().build();

        private Builder() {
        }

        public Builder setHttpParams(HttpParams httpParams) {
            this.httpParams = httpParams;
            return this;
        }

        public Builder setService(Service service) {
            this.service = service;
            return this;
        }

        public FulcioClientGrpc build() {
            Preconditions.checkNotNull((Object)this.service);
            return new FulcioClientGrpc(this.httpParams, this.service.getUrl());
        }
    }
}

