/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.fulcio.client;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.fulcio.client.CertificateRequest;
import dev.sigstore.fulcio.v2.PublicKeyAlgorithm;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CertificateRequest", generator="Immutables")
@Immutable
public final class ImmutableCertificateRequest
implements CertificateRequest {
    private final PublicKey publicKey;
    private final PublicKeyAlgorithm publicKeyAlgorithm;
    private final byte[] proofOfPossession;
    private final String idToken;

    private ImmutableCertificateRequest(PublicKey publicKey, PublicKeyAlgorithm publicKeyAlgorithm, byte[] proofOfPossession, String idToken) {
        this.publicKey = publicKey;
        this.publicKeyAlgorithm = publicKeyAlgorithm;
        this.proofOfPossession = proofOfPossession;
        this.idToken = idToken;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public PublicKeyAlgorithm getPublicKeyAlgorithm() {
        return this.publicKeyAlgorithm;
    }

    @Override
    public byte[] getProofOfPossession() {
        return (byte[])this.proofOfPossession.clone();
    }

    @Override
    public String getIdToken() {
        return this.idToken;
    }

    public final ImmutableCertificateRequest withPublicKey(PublicKey value) {
        if (this.publicKey == value) {
            return this;
        }
        PublicKey newValue = Objects.requireNonNull(value, "publicKey");
        return new ImmutableCertificateRequest(newValue, this.publicKeyAlgorithm, this.proofOfPossession, this.idToken);
    }

    public final ImmutableCertificateRequest withPublicKeyAlgorithm(PublicKeyAlgorithm value) {
        PublicKeyAlgorithm newValue = Objects.requireNonNull(value, "publicKeyAlgorithm");
        if (this.publicKeyAlgorithm == newValue) {
            return this;
        }
        return new ImmutableCertificateRequest(this.publicKey, newValue, this.proofOfPossession, this.idToken);
    }

    public final ImmutableCertificateRequest withProofOfPossession(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableCertificateRequest(this.publicKey, this.publicKeyAlgorithm, newValue, this.idToken);
    }

    public final ImmutableCertificateRequest withIdToken(String value) {
        String newValue = Objects.requireNonNull(value, "idToken");
        if (this.idToken.equals(newValue)) {
            return this;
        }
        return new ImmutableCertificateRequest(this.publicKey, this.publicKeyAlgorithm, this.proofOfPossession, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCertificateRequest && this.equalTo(0, (ImmutableCertificateRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableCertificateRequest another) {
        return this.publicKey.equals(another.publicKey) && this.publicKeyAlgorithm.equals((Object)another.publicKeyAlgorithm) && Arrays.equals(this.proofOfPossession, another.proofOfPossession) && this.idToken.equals(another.idToken);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.publicKey.hashCode();
        h += (h << 5) + this.publicKeyAlgorithm.hashCode();
        h += (h << 5) + Arrays.hashCode(this.proofOfPossession);
        h += (h << 5) + this.idToken.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CertificateRequest").omitNullValues().add("publicKey", (Object)this.publicKey).add("publicKeyAlgorithm", (Object)this.publicKeyAlgorithm).add("proofOfPossession", (Object)Arrays.toString(this.proofOfPossession)).add("idToken", (Object)this.idToken).toString();
    }

    public static ImmutableCertificateRequest copyOf(CertificateRequest instance) {
        if (instance instanceof ImmutableCertificateRequest) {
            return (ImmutableCertificateRequest)instance;
        }
        return ImmutableCertificateRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CertificateRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PUBLIC_KEY = 1L;
        private static final long INIT_BIT_PUBLIC_KEY_ALGORITHM = 2L;
        private static final long INIT_BIT_PROOF_OF_POSSESSION = 4L;
        private static final long INIT_BIT_ID_TOKEN = 8L;
        private long initBits = 15L;
        @Nullable
        private PublicKey publicKey;
        @Nullable
        private PublicKeyAlgorithm publicKeyAlgorithm;
        @Nullable
        private byte[] proofOfPossession;
        @Nullable
        private String idToken;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CertificateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.publicKey(instance.getPublicKey());
            this.publicKeyAlgorithm(instance.getPublicKeyAlgorithm());
            this.proofOfPossession(instance.getProofOfPossession());
            this.idToken(instance.getIdToken());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicKey(PublicKey publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicKeyAlgorithm(PublicKeyAlgorithm publicKeyAlgorithm) {
            this.publicKeyAlgorithm = Objects.requireNonNull(publicKeyAlgorithm, "publicKeyAlgorithm");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder proofOfPossession(byte ... proofOfPossession) {
            this.proofOfPossession = (byte[])proofOfPossession.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder idToken(String idToken) {
            this.idToken = Objects.requireNonNull(idToken, "idToken");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableCertificateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCertificateRequest(this.publicKey, this.publicKeyAlgorithm, this.proofOfPossession, this.idToken);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("publicKey");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("publicKeyAlgorithm");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("proofOfPossession");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("idToken");
            }
            return "Cannot build CertificateRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

