/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.http;

import java.net.URI;
import java.net.URISyntaxException;

public final class URIFormat {
    private URIFormat() {
    }

    public static URI addTrailingSlash(URI input) {
        String path = input.getPath();
        if (path == null || path.isEmpty()) {
            path = "";
        } else if (path.endsWith("/")) {
            return input;
        }
        try {
            return new URI(input.getScheme(), input.getAuthority(), path + "/", input.getQuery(), input.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not append slash to invalid URI: " + String.valueOf(input), e);
        }
    }

    public static URI appendPath(URI base, String path) {
        String relativePath = path.replaceAll("^/+", "");
        return URIFormat.addTrailingSlash(base).resolve(relativePath);
    }
}

