/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.http;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.logging.Logger;
import org.apache.http.client.utils.DateUtils;

public class UnsuccessfulResponseHandler
implements HttpUnsuccessfulResponseHandler {
    private static final int MAX_RETRIES = 10;
    private static final Logger log = Logger.getLogger(UnsuccessfulResponseHandler.class.getName());
    private final Sleeper sleeper;
    private final BackOff exponentialBackOff;
    private int currentRetries = 0;

    public static UnsuccessfulResponseHandler newUnsuccessfulResponseHandler() {
        return new UnsuccessfulResponseHandler(Sleeper.DEFAULT, new ExponentialBackOff());
    }

    @VisibleForTesting
    UnsuccessfulResponseHandler(Sleeper sleeper, ExponentialBackOff exponentialBackOff) {
        this.sleeper = sleeper;
        this.exponentialBackOff = exponentialBackOff;
    }

    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
        if (!supportsRetry) {
            return false;
        }
        if (this.currentRetries >= 10) {
            return false;
        }
        ++this.currentRetries;
        int statusCode = response.getStatusCode();
        if (statusCode / 100 != 5 && statusCode != 429) {
            return false;
        }
        try {
            String retryAfter;
            HttpHeaders headers = response.getHeaders();
            if (headers != null && (retryAfter = headers.getRetryAfter()) != null && (statusCode == 429 || statusCode == 503)) {
                try {
                    return this.handleRetryAfter(retryAfter);
                }
                catch (NumberFormatException ignored) {
                    log.warning("Retry-After header in request to " + String.valueOf(request.getUrl()) + " was invalid (" + retryAfter + ")");
                }
            }
            return BackOffUtils.next((Sleeper)this.sleeper, (BackOff)this.exponentialBackOff);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private boolean handleRetryAfter(String retryAfter) throws InterruptedException, IOException {
        long delay = this.calculateBackoff(retryAfter, Instant.now());
        if (delay > 0L) {
            this.sleeper.sleep(delay);
        }
        return true;
    }

    @VisibleForTesting
    long calculateBackoff(String retryAfter, Instant now) throws NumberFormatException {
        Date date = DateUtils.parseDate((String)retryAfter);
        if (date != null) {
            return date.toInstant().toEpochMilli() - now.toEpochMilli();
        }
        return Long.parseLong(retryAfter) * 1000L;
    }
}

