/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.merkle;

import com.google.common.hash.Hashing;
import dev.sigstore.merkle.InclusionProofVerificationException;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class InclusionProofVerifier {
    public static void verify(byte[] leafHash, long logIndex, long treeSize, List<byte[]> proofHashes, byte[] expectedRootHash) throws InclusionProofVerificationException {
        byte[] currentHash = leafHash;
        long nodeIndex = logIndex;
        long totalNodes = treeSize - 1L;
        for (byte[] hash : proofHashes) {
            if (totalNodes == 0L) {
                throw new InclusionProofVerificationException("Inclusion proof failed, ended prematurely");
            }
            if (nodeIndex == totalNodes || nodeIndex % 2L == 1L) {
                currentHash = InclusionProofVerifier.hashChildren(hash, currentHash);
                while (nodeIndex % 2L == 0L) {
                    nodeIndex >>= 1;
                    totalNodes >>= 1;
                }
            } else {
                currentHash = InclusionProofVerifier.hashChildren(currentHash, hash);
            }
            nodeIndex >>= 1;
            totalNodes >>= 1;
        }
        if (!Arrays.equals(currentHash, expectedRootHash)) {
            throw new InclusionProofVerificationException("Calculated inclusion proof root hash does not match provided root hash\ncalculated: " + Hex.toHexString((byte[])currentHash) + "\nprovided:   " + Hex.toHexString((byte[])expectedRootHash));
        }
    }

    public static byte[] hashChildren(byte[] left, byte[] right) {
        return Hashing.sha256().newHasher().putByte((byte)1).putBytes(left).putBytes(right).hash().asBytes();
    }
}

