/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.oidc.client;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import dev.sigstore.http.HttpClients;
import dev.sigstore.http.HttpParams;
import dev.sigstore.oidc.client.ImmutableOidcToken;
import dev.sigstore.oidc.client.OidcClient;
import dev.sigstore.oidc.client.OidcException;
import dev.sigstore.oidc.client.OidcToken;
import io.grpc.Internal;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

public class GithubActionsOidcClient
implements OidcClient {
    private static final Logger log = Logger.getLogger(GithubActionsOidcClient.class.getName());
    static final String GITHUB_ACTIONS_KEY = "GITHUB_ACTIONS";
    static final String REQUEST_TOKEN_KEY = "ACTIONS_ID_TOKEN_REQUEST_TOKEN";
    static final String REQUEST_URL_KEY = "ACTIONS_ID_TOKEN_REQUEST_URL";
    private static final String DEFAULT_AUDIENCE = "sigstore";
    private final String audience;
    private final HttpParams httpParams;

    public static Builder builder() {
        return new Builder();
    }

    private GithubActionsOidcClient(HttpParams httpParams, String audience) {
        this.audience = audience;
        this.httpParams = httpParams;
    }

    @Override
    public boolean isEnabled(Map<String, String> env) {
        String githubActions = env.get(GITHUB_ACTIONS_KEY);
        if (githubActions == null || githubActions.isEmpty()) {
            log.fine("Github env not detected: skipping github actions oidc");
            return false;
        }
        String bearer = env.get(REQUEST_TOKEN_KEY);
        String urlBase = env.get(REQUEST_URL_KEY);
        if (bearer == null || bearer.isEmpty() || urlBase == null || urlBase.isEmpty()) {
            log.info("Github env detected, but github idtoken not found: skipping github actions oidc");
            return false;
        }
        return true;
    }

    @Override
    public OidcToken getIDToken(Map<String, String> env) throws OidcException {
        String bearer = env.get(REQUEST_TOKEN_KEY);
        String urlBase = env.get(REQUEST_URL_KEY);
        if (bearer == null) {
            throw new OidcException("Could not get github actions environment variable 'ACTIONS_ID_TOKEN_REQUEST_TOKEN'");
        }
        if (urlBase == null) {
            throw new OidcException("Could not get github actions environment variable 'ACTIONS_ID_TOKEN_REQUEST_URL'");
        }
        GenericUrl url = new GenericUrl(urlBase + "&audience=" + this.audience);
        try {
            HttpRequest req = HttpClients.newRequestFactory(this.httpParams).buildGetRequest(url);
            req.setParser((ObjectParser)new GsonFactory().createJsonObjectParser());
            req.getHeaders().setAuthorization("Bearer " + bearer);
            req.getHeaders().setAccept("application/json; api-version=2.0");
            req.getHeaders().setContentType("application/json");
            GithubOidcJsonResponse resp = (GithubOidcJsonResponse)((Object)req.execute().parseAs(GithubOidcJsonResponse.class));
            String idToken = resp.getValue();
            JsonWebSignature jws = JsonWebSignature.parse((JsonFactory)new GsonFactory(), (String)idToken);
            return ImmutableOidcToken.builder().idToken(idToken).issuer(jws.getPayload().getIssuer()).subjectAlternativeName(jws.getPayload().getSubject()).build();
        }
        catch (IOException e) {
            throw new OidcException("Could not obtain github actions oidc token", e);
        }
    }

    public static class Builder {
        private HttpParams httpParams = HttpParams.builder().build();
        private String audience = "sigstore";

        private Builder() {
        }

        public Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public Builder httpParams(HttpParams httpParams) {
            this.httpParams = httpParams;
            return this;
        }

        public GithubActionsOidcClient build() {
            return new GithubActionsOidcClient(this.httpParams, this.audience);
        }
    }

    @Internal
    public static class GithubOidcJsonResponse
    extends GenericJson {
        @Key(value="value")
        private String value;

        String getValue() {
            return this.value;
        }
    }
}

