/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.oidc.client;

import com.google.common.collect.ImmutableList;
import dev.sigstore.oidc.client.GithubActionsOidcClient;
import dev.sigstore.oidc.client.OidcClient;
import dev.sigstore.oidc.client.OidcException;
import dev.sigstore.oidc.client.OidcToken;
import dev.sigstore.oidc.client.WebOidcClient;
import dev.sigstore.trustroot.Service;
import java.util.Map;
import java.util.logging.Logger;

public class OidcClients {
    private static final Logger log = Logger.getLogger(OidcClients.class.getName());
    private final ImmutableList<OidcClient> clients;
    private final Map<String, String> env;

    public static OidcClients of(OidcClient ... clients) {
        return new OidcClients((ImmutableList<OidcClient>)ImmutableList.copyOf((Object[])clients), System.getenv());
    }

    public static OidcClients from(Service oidcService) {
        return OidcClients.of(GithubActionsOidcClient.builder().build(), WebOidcClient.builder().setIssuer(oidcService).build());
    }

    private OidcClients(ImmutableList<OidcClient> clients, Map<String, String> env) {
        this.clients = clients;
        this.env = env;
    }

    public OidcToken getIDToken() throws OidcException {
        for (OidcClient client : this.clients) {
            if (!client.isEnabled(this.env)) continue;
            return client.getIDToken(this.env);
        }
        log.info("Could not find an oidc provider, if you are in CI make sure the token is available to the sigstore signing process");
        throw new OidcException("Could not find an oidc provider");
    }
}

