/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.oidc.client;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import dev.sigstore.oidc.client.ImmutableOidcToken;
import dev.sigstore.oidc.client.OidcClient;
import dev.sigstore.oidc.client.OidcException;
import dev.sigstore.oidc.client.OidcToken;
import java.io.IOException;
import java.util.Map;

public class TokenStringOidcClient
implements OidcClient {
    private final TokenStringProvider idTokenProvider;

    TokenStringOidcClient(TokenStringProvider provider) {
        this.idTokenProvider = provider;
    }

    public static TokenStringOidcClient from(TokenStringProvider provider) {
        return new TokenStringOidcClient(provider);
    }

    public static TokenStringOidcClient from(String token) {
        return new TokenStringOidcClient(() -> token);
    }

    @Override
    public boolean isEnabled(Map<String, String> env) {
        return true;
    }

    @Override
    public OidcToken getIDToken(Map<String, String> env) throws OidcException {
        try {
            String idToken = this.idTokenProvider.getTokenString();
            JsonWebSignature jws = JsonWebSignature.parse((JsonFactory)new GsonFactory(), (String)idToken);
            return ImmutableOidcToken.builder().idToken(idToken).issuer(jws.getPayload().getIssuer()).subjectAlternativeName(jws.getPayload().getSubject()).build();
        }
        catch (IOException e) {
            throw new OidcException("Failed to parse JWT", e);
        }
        catch (Exception e) {
            throw new OidcException("Failed to obtain token", e);
        }
    }

    @FunctionalInterface
    public static interface TokenStringProvider {
        public String getTokenString() throws Exception;
    }
}

