/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import dev.sigstore.AlgorithmRegistry;
import dev.sigstore.encryption.certificates.Certificates;
import dev.sigstore.proto.common.v1.HashAlgorithm;
import dev.sigstore.proto.common.v1.PublicKeyDetails;
import dev.sigstore.proto.common.v1.X509Certificate;
import dev.sigstore.proto.rekor.v1.InclusionProof;
import dev.sigstore.proto.rekor.v1.TransparencyLogEntry;
import dev.sigstore.rekor.client.ImmutableInclusionProof;
import dev.sigstore.rekor.client.ImmutableRekorEntry;
import dev.sigstore.rekor.client.ImmutableVerification;
import dev.sigstore.rekor.client.RekorEntry;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.util.encoders.Hex;

public class ProtoMutators {
    public static CertPath toCertPath(List<X509Certificate> certificates) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> converted = new ArrayList<Certificate>(certificates.size());
        for (X509Certificate cert : certificates) {
            converted.add(Certificates.fromDer(cert.getRawBytes().toByteArray()));
        }
        return cf.generateCertPath(converted);
    }

    public static Instant toInstant(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static X509Certificate fromCert(java.security.cert.X509Certificate certificate) throws CertificateEncodingException {
        byte[] encoded = certificate.getEncoded();
        return X509Certificate.newBuilder().setRawBytes(ByteString.copyFrom((byte[])encoded)).build();
    }

    public static HashAlgorithm toProtoHashAlgorithm(AlgorithmRegistry.HashAlgorithm algorithm) {
        if (Objects.requireNonNull(algorithm) == AlgorithmRegistry.HashAlgorithm.SHA2_256) {
            return HashAlgorithm.SHA2_256;
        }
        throw new IllegalStateException("Unknown hash algorithm: " + String.valueOf((Object)algorithm));
    }

    public static PublicKeyDetails toPublicKeyDetails(AlgorithmRegistry.SigningAlgorithm algorithm) {
        switch (algorithm) {
            case PKIX_RSA_PKCS1V15_2048_SHA256: {
                return PublicKeyDetails.PKIX_RSA_PKCS1V15_2048_SHA256;
            }
            case PKIX_RSA_PKCS1V15_3072_SHA256: {
                return PublicKeyDetails.PKIX_RSA_PKCS1V15_3072_SHA256;
            }
            case PKIX_RSA_PKCS1V15_4096_SHA256: {
                return PublicKeyDetails.PKIX_RSA_PKCS1V15_4096_SHA256;
            }
            case PKIX_ECDSA_P256_SHA_256: {
                return PublicKeyDetails.PKIX_ECDSA_P256_SHA_256;
            }
        }
        throw new IllegalStateException("Unknown algorithm: " + String.valueOf((Object)algorithm));
    }

    public static RekorEntry toRekorEntry(TransparencyLogEntry tle) {
        ImmutableRekorEntry.Builder builder = ImmutableRekorEntry.builder();
        builder.logIndex(tle.getLogIndex());
        builder.logID(Hex.toHexString((byte[])tle.getLogId().getKeyId().toByteArray()));
        builder.integratedTime(tle.getIntegratedTime());
        builder.body(Base64.getEncoder().encodeToString(tle.getCanonicalizedBody().toByteArray()));
        ImmutableVerification.Builder verificationBuilder = ImmutableVerification.builder();
        if (tle.hasInclusionPromise() && !tle.getInclusionPromise().getSignedEntryTimestamp().isEmpty()) {
            verificationBuilder.signedEntryTimestamp(Base64.getEncoder().encodeToString(tle.getInclusionPromise().getSignedEntryTimestamp().toByteArray()));
        }
        if (tle.hasInclusionProof()) {
            InclusionProof ipProto = tle.getInclusionProof();
            ImmutableInclusionProof.Builder ipBuilder = ImmutableInclusionProof.builder();
            ipBuilder.logIndex(ipProto.getLogIndex());
            ipBuilder.rootHash(Hex.toHexString((byte[])ipProto.getRootHash().toByteArray()));
            ipBuilder.treeSize(ipProto.getTreeSize());
            ipBuilder.checkpoint(ipProto.getCheckpoint().getEnvelope());
            ipProto.getHashesList().forEach(hash -> ipBuilder.addHashes(Hex.toHexString((byte[])hash.toByteArray())));
            verificationBuilder.inclusionProof(ipBuilder.build());
        }
        builder.verification(verificationBuilder.build());
        return builder.build();
    }
}

