/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.rekor.client.RekorEntry;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RekorEntry.Checkpoint", generator="Immutables")
@Immutable
public final class ImmutableCheckpoint
implements RekorEntry.Checkpoint {
    private final String signedData;
    private final String origin;
    private final Long size;
    private final String base64Hash;
    private final ImmutableList<RekorEntry.CheckpointSignature> signatures;

    private ImmutableCheckpoint(String signedData, String origin, Long size, String base64Hash, ImmutableList<RekorEntry.CheckpointSignature> signatures) {
        this.signedData = signedData;
        this.origin = origin;
        this.size = size;
        this.base64Hash = base64Hash;
        this.signatures = signatures;
    }

    @Override
    public String getSignedData() {
        return this.signedData;
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    @Override
    public String getBase64Hash() {
        return this.base64Hash;
    }

    public ImmutableList<RekorEntry.CheckpointSignature> getSignatures() {
        return this.signatures;
    }

    public final ImmutableCheckpoint withSignedData(String value) {
        String newValue = Objects.requireNonNull(value, "signedData");
        if (this.signedData.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckpoint(newValue, this.origin, this.size, this.base64Hash, this.signatures);
    }

    public final ImmutableCheckpoint withOrigin(String value) {
        String newValue = Objects.requireNonNull(value, "origin");
        if (this.origin.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckpoint(this.signedData, newValue, this.size, this.base64Hash, this.signatures);
    }

    public final ImmutableCheckpoint withSize(Long value) {
        Long newValue = Objects.requireNonNull(value, "size");
        if (this.size.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckpoint(this.signedData, this.origin, newValue, this.base64Hash, this.signatures);
    }

    public final ImmutableCheckpoint withBase64Hash(String value) {
        String newValue = Objects.requireNonNull(value, "base64Hash");
        if (this.base64Hash.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckpoint(this.signedData, this.origin, this.size, newValue, this.signatures);
    }

    public final ImmutableCheckpoint withSignatures(RekorEntry.CheckpointSignature ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCheckpoint(this.signedData, this.origin, this.size, this.base64Hash, (ImmutableList<RekorEntry.CheckpointSignature>)newValue);
    }

    public final ImmutableCheckpoint withSignatures(Iterable<? extends RekorEntry.CheckpointSignature> elements) {
        if (this.signatures == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCheckpoint(this.signedData, this.origin, this.size, this.base64Hash, (ImmutableList<RekorEntry.CheckpointSignature>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckpoint && this.equalTo(0, (ImmutableCheckpoint)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckpoint another) {
        return this.signedData.equals(another.signedData) && this.origin.equals(another.origin) && this.size.equals(another.size) && this.base64Hash.equals(another.base64Hash) && this.signatures.equals(another.signatures);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.signedData.hashCode();
        h += (h << 5) + this.origin.hashCode();
        h += (h << 5) + this.size.hashCode();
        h += (h << 5) + this.base64Hash.hashCode();
        h += (h << 5) + this.signatures.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Checkpoint").omitNullValues().add("signedData", (Object)this.signedData).add("origin", (Object)this.origin).add("size", (Object)this.size).add("base64Hash", (Object)this.base64Hash).add("signatures", this.signatures).toString();
    }

    public static ImmutableCheckpoint copyOf(RekorEntry.Checkpoint instance) {
        if (instance instanceof ImmutableCheckpoint) {
            return (ImmutableCheckpoint)instance;
        }
        return ImmutableCheckpoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RekorEntry.Checkpoint", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SIGNED_DATA = 1L;
        private static final long INIT_BIT_ORIGIN = 2L;
        private static final long INIT_BIT_SIZE = 4L;
        private static final long INIT_BIT_BASE64_HASH = 8L;
        private long initBits = 15L;
        @Nullable
        private String signedData;
        @Nullable
        private String origin;
        @Nullable
        private Long size;
        @Nullable
        private String base64Hash;
        private ImmutableList.Builder<RekorEntry.CheckpointSignature> signatures = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RekorEntry.Checkpoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.signedData(instance.getSignedData());
            this.origin(instance.getOrigin());
            this.size(instance.getSize());
            this.base64Hash(instance.getBase64Hash());
            this.addAllSignatures(instance.getSignatures());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signedData(String signedData) {
            this.signedData = Objects.requireNonNull(signedData, "signedData");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder origin(String origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder size(Long size) {
            this.size = Objects.requireNonNull(size, "size");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder base64Hash(String base64Hash) {
            this.base64Hash = Objects.requireNonNull(base64Hash, "base64Hash");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignatures(RekorEntry.CheckpointSignature element) {
            this.signatures.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignatures(RekorEntry.CheckpointSignature ... elements) {
            this.signatures.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signatures(Iterable<? extends RekorEntry.CheckpointSignature> elements) {
            this.signatures = ImmutableList.builder();
            return this.addAllSignatures(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSignatures(Iterable<? extends RekorEntry.CheckpointSignature> elements) {
            this.signatures.addAll(elements);
            return this;
        }

        public ImmutableCheckpoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckpoint(this.signedData, this.origin, this.size, this.base64Hash, (ImmutableList<RekorEntry.CheckpointSignature>)this.signatures.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("signedData");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("base64Hash");
            }
            return "Cannot build Checkpoint, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

