/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import dev.sigstore.rekor.client.RekorEntryBody;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RekorEntryBody", generator="Immutables")
@Immutable
public final class ImmutableRekorEntryBody
implements RekorEntryBody {
    private final String apiVersion;
    private final String kind;
    private final JsonElement spec;

    private ImmutableRekorEntryBody(String apiVersion, String kind, JsonElement spec) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.spec = spec;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public JsonElement getSpec() {
        return this.spec;
    }

    public final ImmutableRekorEntryBody withApiVersion(String value) {
        String newValue = Objects.requireNonNull(value, "apiVersion");
        if (this.apiVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableRekorEntryBody(newValue, this.kind, this.spec);
    }

    public final ImmutableRekorEntryBody withKind(String value) {
        String newValue = Objects.requireNonNull(value, "kind");
        if (this.kind.equals(newValue)) {
            return this;
        }
        return new ImmutableRekorEntryBody(this.apiVersion, newValue, this.spec);
    }

    public final ImmutableRekorEntryBody withSpec(JsonElement value) {
        if (this.spec == value) {
            return this;
        }
        JsonElement newValue = Objects.requireNonNull(value, "spec");
        return new ImmutableRekorEntryBody(this.apiVersion, this.kind, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRekorEntryBody && this.equalTo(0, (ImmutableRekorEntryBody)another);
    }

    private boolean equalTo(int synthetic, ImmutableRekorEntryBody another) {
        return this.apiVersion.equals(another.apiVersion) && this.kind.equals(another.kind) && this.spec.equals(another.spec);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.apiVersion.hashCode();
        h += (h << 5) + this.kind.hashCode();
        h += (h << 5) + this.spec.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RekorEntryBody").omitNullValues().add("apiVersion", (Object)this.apiVersion).add("kind", (Object)this.kind).add("spec", (Object)this.spec).toString();
    }

    public static ImmutableRekorEntryBody copyOf(RekorEntryBody instance) {
        if (instance instanceof ImmutableRekorEntryBody) {
            return (ImmutableRekorEntryBody)instance;
        }
        return ImmutableRekorEntryBody.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RekorEntryBody", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_API_VERSION = 1L;
        private static final long INIT_BIT_KIND = 2L;
        private static final long INIT_BIT_SPEC = 4L;
        private long initBits = 7L;
        @Nullable
        private String apiVersion;
        @Nullable
        private String kind;
        @Nullable
        private JsonElement spec;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RekorEntryBody instance) {
            Objects.requireNonNull(instance, "instance");
            this.apiVersion(instance.getApiVersion());
            this.kind(instance.getKind());
            this.spec(instance.getSpec());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder apiVersion(String apiVersion) {
            this.apiVersion = Objects.requireNonNull(apiVersion, "apiVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder kind(String kind) {
            this.kind = Objects.requireNonNull(kind, "kind");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder spec(JsonElement spec) {
            this.spec = Objects.requireNonNull(spec, "spec");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRekorEntryBody build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRekorEntryBody(this.apiVersion, this.kind, this.spec);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("apiVersion");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("kind");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("spec");
            }
            return "Cannot build RekorEntryBody, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

