/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RekorResponse", generator="Immutables")
@Immutable
public final class ImmutableRekorResponse
implements RekorResponse {
    private final URI entryLocation;
    private final RekorEntry entry;
    private final String uuid;
    private final String raw;

    private ImmutableRekorResponse(URI entryLocation, RekorEntry entry, String uuid, String raw) {
        this.entryLocation = entryLocation;
        this.entry = entry;
        this.uuid = uuid;
        this.raw = raw;
    }

    @Override
    public URI getEntryLocation() {
        return this.entryLocation;
    }

    @Override
    public RekorEntry getEntry() {
        return this.entry;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getRaw() {
        return this.raw;
    }

    public final ImmutableRekorResponse withEntryLocation(URI value) {
        if (this.entryLocation == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "entryLocation");
        return new ImmutableRekorResponse(newValue, this.entry, this.uuid, this.raw);
    }

    public final ImmutableRekorResponse withEntry(RekorEntry value) {
        if (this.entry == value) {
            return this;
        }
        RekorEntry newValue = Objects.requireNonNull(value, "entry");
        return new ImmutableRekorResponse(this.entryLocation, newValue, this.uuid, this.raw);
    }

    public final ImmutableRekorResponse withUuid(String value) {
        String newValue = Objects.requireNonNull(value, "uuid");
        if (this.uuid.equals(newValue)) {
            return this;
        }
        return new ImmutableRekorResponse(this.entryLocation, this.entry, newValue, this.raw);
    }

    public final ImmutableRekorResponse withRaw(String value) {
        String newValue = Objects.requireNonNull(value, "raw");
        if (this.raw.equals(newValue)) {
            return this;
        }
        return new ImmutableRekorResponse(this.entryLocation, this.entry, this.uuid, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRekorResponse && this.equalTo(0, (ImmutableRekorResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableRekorResponse another) {
        return this.entryLocation.equals(another.entryLocation) && this.entry.equals(another.entry) && this.uuid.equals(another.uuid) && this.raw.equals(another.raw);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entryLocation.hashCode();
        h += (h << 5) + this.entry.hashCode();
        h += (h << 5) + this.uuid.hashCode();
        h += (h << 5) + this.raw.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RekorResponse").omitNullValues().add("entryLocation", (Object)this.entryLocation).add("entry", (Object)this.entry).add("uuid", (Object)this.uuid).add("raw", (Object)this.raw).toString();
    }

    public static ImmutableRekorResponse copyOf(RekorResponse instance) {
        if (instance instanceof ImmutableRekorResponse) {
            return (ImmutableRekorResponse)instance;
        }
        return ImmutableRekorResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RekorResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENTRY_LOCATION = 1L;
        private static final long INIT_BIT_ENTRY = 2L;
        private static final long INIT_BIT_UUID = 4L;
        private static final long INIT_BIT_RAW = 8L;
        private long initBits = 15L;
        @Nullable
        private URI entryLocation;
        @Nullable
        private RekorEntry entry;
        @Nullable
        private String uuid;
        @Nullable
        private String raw;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RekorResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.entryLocation(instance.getEntryLocation());
            this.entry(instance.getEntry());
            this.uuid(instance.getUuid());
            this.raw(instance.getRaw());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder entryLocation(URI entryLocation) {
            this.entryLocation = Objects.requireNonNull(entryLocation, "entryLocation");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder entry(RekorEntry entry) {
            this.entry = Objects.requireNonNull(entry, "entry");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uuid(String uuid) {
            this.uuid = Objects.requireNonNull(uuid, "uuid");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder raw(String raw) {
            this.raw = Objects.requireNonNull(raw, "raw");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableRekorResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRekorResponse(this.entryLocation, this.entry, this.uuid, this.raw);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entryLocation");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("entry");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("uuid");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("raw");
            }
            return "Cannot build RekorResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

