/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.rekor.client.RekorEntry;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RekorEntry.Verification", generator="Immutables")
@Immutable
public final class ImmutableVerification
implements RekorEntry.Verification {
    @Nullable
    private final String signedEntryTimestamp;
    @Nullable
    private final RekorEntry.InclusionProof inclusionProof;

    private ImmutableVerification(@Nullable String signedEntryTimestamp, @Nullable RekorEntry.InclusionProof inclusionProof) {
        this.signedEntryTimestamp = signedEntryTimestamp;
        this.inclusionProof = inclusionProof;
    }

    @Override
    @Nullable
    public String getSignedEntryTimestamp() {
        return this.signedEntryTimestamp;
    }

    @Override
    @Nullable
    public RekorEntry.InclusionProof getInclusionProof() {
        return this.inclusionProof;
    }

    public final ImmutableVerification withSignedEntryTimestamp(@Nullable String value) {
        if (Objects.equals(this.signedEntryTimestamp, value)) {
            return this;
        }
        return new ImmutableVerification(value, this.inclusionProof);
    }

    public final ImmutableVerification withInclusionProof(@Nullable RekorEntry.InclusionProof value) {
        if (this.inclusionProof == value) {
            return this;
        }
        return new ImmutableVerification(this.signedEntryTimestamp, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVerification && this.equalTo(0, (ImmutableVerification)another);
    }

    private boolean equalTo(int synthetic, ImmutableVerification another) {
        return Objects.equals(this.signedEntryTimestamp, another.signedEntryTimestamp) && Objects.equals(this.inclusionProof, another.inclusionProof);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.signedEntryTimestamp);
        h += (h << 5) + Objects.hashCode(this.inclusionProof);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Verification").omitNullValues().add("signedEntryTimestamp", (Object)this.signedEntryTimestamp).add("inclusionProof", (Object)this.inclusionProof).toString();
    }

    public static ImmutableVerification copyOf(RekorEntry.Verification instance) {
        if (instance instanceof ImmutableVerification) {
            return (ImmutableVerification)instance;
        }
        return ImmutableVerification.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RekorEntry.Verification", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String signedEntryTimestamp;
        @Nullable
        private RekorEntry.InclusionProof inclusionProof;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RekorEntry.Verification instance) {
            RekorEntry.InclusionProof inclusionProofValue;
            Objects.requireNonNull(instance, "instance");
            String signedEntryTimestampValue = instance.getSignedEntryTimestamp();
            if (signedEntryTimestampValue != null) {
                this.signedEntryTimestamp(signedEntryTimestampValue);
            }
            if ((inclusionProofValue = instance.getInclusionProof()) != null) {
                this.inclusionProof(inclusionProofValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signedEntryTimestamp(@Nullable String signedEntryTimestamp) {
            this.signedEntryTimestamp = signedEntryTimestamp;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder inclusionProof(@Nullable RekorEntry.InclusionProof inclusionProof) {
            this.inclusionProof = inclusionProof;
            return this;
        }

        public ImmutableVerification build() {
            return new ImmutableVerification(this.signedEntryTimestamp, this.inclusionProof);
        }
    }
}

