/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.gson.JsonParseException;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorTypeException;
import dev.sigstore.rekor.dsse.v0_0_1.Dsse;
import dev.sigstore.rekor.hashedRekord.v0_0_1.HashedRekord;

public class RekorTypes {
    public static HashedRekord getHashedRekord(RekorEntry entry) throws RekorTypeException {
        RekorTypes.expect(entry, "hashedrekord", "0.0.1");
        try {
            return (HashedRekord)GsonSupplier.GSON.get().fromJson(entry.getBodyDecoded().getSpec(), HashedRekord.class);
        }
        catch (JsonParseException jpe) {
            throw new RekorTypeException("Could not parse hashrekord:0.0.1", jpe);
        }
    }

    public static Dsse getDsse(RekorEntry entry) throws RekorTypeException {
        RekorTypes.expect(entry, "dsse", "0.0.1");
        try {
            return (Dsse)GsonSupplier.GSON.get().fromJson(entry.getBodyDecoded().getSpec(), Dsse.class);
        }
        catch (JsonParseException jpe) {
            throw new RekorTypeException("Could not parse dsse:0.0.1", jpe);
        }
    }

    private static void expect(RekorEntry entry, String expectedKind, String expectedApiVersion) throws RekorTypeException {
        String kind = entry.getBodyDecoded().getKind();
        String apiVersion = entry.getBodyDecoded().getApiVersion();
        if (!kind.equals(expectedKind) || !apiVersion.equals(expectedApiVersion)) {
            throw new RekorTypeException("Expecting type " + expectedKind + ":" + expectedApiVersion + ", but found " + kind + ":" + apiVersion);
        }
    }
}

