/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.client;

import com.google.common.hash.Hashing;
import dev.sigstore.encryption.signers.Verifier;
import dev.sigstore.encryption.signers.Verifiers;
import dev.sigstore.merkle.InclusionProofVerificationException;
import dev.sigstore.merkle.InclusionProofVerifier;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorParseException;
import dev.sigstore.rekor.client.RekorVerificationException;
import dev.sigstore.trustroot.SigstoreTrustedRoot;
import dev.sigstore.trustroot.TransparencyLog;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.util.encoders.Hex;

public class RekorVerifier {
    private final List<TransparencyLog> tlogs;

    public static RekorVerifier newRekorVerifier(SigstoreTrustedRoot trustRoot) {
        return RekorVerifier.newRekorVerifier(trustRoot.getTLogs());
    }

    public static RekorVerifier newRekorVerifier(List<TransparencyLog> tlogs) {
        return new RekorVerifier(tlogs);
    }

    private RekorVerifier(List<TransparencyLog> tlogs) {
        this.tlogs = tlogs;
    }

    public void verifyEntry(RekorEntry entry) throws RekorVerificationException {
        if (entry.getVerification().getInclusionProof() == null) {
            throw new RekorVerificationException("No inclusion proof in entry.");
        }
        TransparencyLog tlog = TransparencyLog.find(this.tlogs, Hex.decode((String)entry.getLogID())).orElseThrow(() -> new RekorVerificationException("Log entry (logid) does not match any provided transparency logs."));
        String set = entry.getVerification().getSignedEntryTimestamp();
        if (set != null && !set.isEmpty()) {
            try {
                Verifier verifier = Verifiers.newVerifier(tlog.getPublicKey().toJavaPublicKey());
                if (!verifier.verify(entry.getSignableContent(), Base64.getDecoder().decode(entry.getVerification().getSignedEntryTimestamp()))) {
                    throw new RekorVerificationException("Entry SET was not valid");
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
                throw new RekorVerificationException("Entry SET verification failed: " + e.getMessage(), e);
            }
        }
        this.verifyInclusionProof(entry);
        this.verifyCheckpoint(entry, tlog);
    }

    private void verifyInclusionProof(RekorEntry entry) throws RekorVerificationException {
        RekorEntry.InclusionProof inclusionProof = entry.getVerification().getInclusionProof();
        byte[] leafHash = Hashing.sha256().newHasher().putByte((byte)0).putBytes(Base64.getDecoder().decode(entry.getBody())).hash().asBytes();
        ArrayList<byte[]> hashes = new ArrayList<byte[]>();
        for (String hash : inclusionProof.getHashes()) {
            hashes.add(Hex.decode((String)hash));
        }
        byte[] expectedRootHash = Hex.decode((String)inclusionProof.getRootHash());
        try {
            InclusionProofVerifier.verify(leafHash, inclusionProof.getLogIndex(), inclusionProof.getTreeSize(), hashes, expectedRootHash);
        }
        catch (InclusionProofVerificationException e) {
            throw new RekorVerificationException("Inclusion proof verification failed", e);
        }
    }

    private void verifyCheckpoint(RekorEntry entry, TransparencyLog tlog) throws RekorVerificationException {
        byte[] checkpointRootHash;
        RekorEntry.Checkpoint parsedCheckpoint;
        try {
            parsedCheckpoint = entry.getVerification().getInclusionProof().parsedCheckpoint();
        }
        catch (RekorParseException ex) {
            throw new RekorVerificationException("Could not parse checkpoint from envelope", ex);
        }
        int MAX_CHECKPOINT_SIGNATURES = 20;
        if (parsedCheckpoint.getSignatures().size() > 20) {
            throw new RekorVerificationException("Checkpoint contains an excessive number of signatures (" + parsedCheckpoint.getSignatures().size() + "), exceeding the maximum allowed of 20");
        }
        byte[] inclusionRootHash = Hex.decode((String)entry.getVerification().getInclusionProof().getRootHash());
        if (!Arrays.equals(inclusionRootHash, checkpointRootHash = Base64.getDecoder().decode(parsedCheckpoint.getBase64Hash()))) {
            throw new RekorVerificationException("Checkpoint root hash does not match root hash provided in inclusion proof");
        }
        Optional<RekorEntry.CheckpointSignature> matchingSig = parsedCheckpoint.getSignatures().stream().filter(sig -> sig.getIdentity().equals(tlog.getBaseUrl().getHost())).findFirst();
        if (!matchingSig.isPresent()) {
            throw new RekorVerificationException("No matching checkpoint signature found for transparency log: " + tlog.getBaseUrl().getHost());
        }
        byte[] keyId = tlog.getLogId().getKeyId();
        byte[] keyHint = Arrays.copyOfRange(keyId, 0, 4);
        if (!Arrays.equals(matchingSig.get().getKeyHint(), keyHint)) {
            throw new RekorVerificationException("Checkpoint key hint did not match provided log public key");
        }
        String signedData = parsedCheckpoint.getSignedData();
        try {
            if (!Verifiers.newVerifier(tlog.getPublicKey().toJavaPublicKey()).verify(signedData.getBytes(StandardCharsets.UTF_8), matchingSig.get().getSignature())) {
                throw new RekorVerificationException("Checkpoint signature was invalid");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException ex) {
            throw new RekorVerificationException("Could not verify checkpoint signature", ex);
        }
    }
}

