/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.dsse.v0_0_1;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;

public class PayloadHash {
    @SerializedName(value="algorithm")
    @Expose
    private Algorithm algorithm;
    @SerializedName(value="value")
    @Expose
    private String value;

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public PayloadHash withAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public PayloadHash withValue(String value) {
        this.value = value;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PayloadHash.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("algorithm");
        sb.append('=');
        sb.append(this.algorithm == null ? "<null>" : this.algorithm);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        result = result * 31 + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PayloadHash)) {
            return false;
        }
        PayloadHash rhs = (PayloadHash)other;
        return (this.value == rhs.value || this.value != null && this.value.equals(rhs.value)) && (this.algorithm == rhs.algorithm || this.algorithm != null && this.algorithm.equals((Object)rhs.algorithm));
    }

    public static enum Algorithm {
        SHA_256("sha256");

        private final String value;
        private static final Map<String, Algorithm> CONSTANTS;

        private Algorithm(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static Algorithm fromValue(String value) {
            Algorithm constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Algorithm>();
            for (Algorithm c : Algorithm.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

