/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.rekor.v2.client;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.Preconditions;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import dev.sigstore.http.HttpClients;
import dev.sigstore.http.HttpParams;
import dev.sigstore.http.ImmutableHttpParams;
import dev.sigstore.proto.rekor.v2.CreateEntryRequest;
import dev.sigstore.proto.rekor.v2.HashedRekordRequestV002;
import dev.sigstore.rekor.client.RekorEntry;
import dev.sigstore.rekor.client.RekorParseException;
import dev.sigstore.rekor.v2.client.RekorV2Client;
import dev.sigstore.trustroot.Service;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;

public class RekorV2ClientHttp
implements RekorV2Client {
    public static final String REKOR_ENTRIES_PATH = "/api/v2/log/entries";
    public static final String REKOR_CHECKPOINT_PATH = "/api/v2/checkpoint";
    private final HttpParams httpParams;
    private final URI uri;

    public static Builder builder() {
        return new Builder();
    }

    private RekorV2ClientHttp(HttpParams httpParams, URI uri) {
        this.uri = uri;
        this.httpParams = httpParams;
    }

    @Override
    public RekorEntry putEntry(HashedRekordRequestV002 hashedRekordRequest) throws IOException, RekorParseException {
        URI rekorPutEndpoint = this.uri.resolve(REKOR_ENTRIES_PATH);
        String jsonPayload = JsonFormat.printer().print((MessageOrBuilder)CreateEntryRequest.newBuilder().setHashedRekordRequestV002(hashedRekordRequest).build());
        HttpRequest req = HttpClients.newRequestFactory(this.httpParams).buildPostRequest(new GenericUrl(rekorPutEndpoint), (HttpContent)ByteArrayContent.fromString((String)"application/json", (String)jsonPayload));
        req.getHeaders().set("Accept", (Object)"application/json");
        req.getHeaders().set("Content-Type", (Object)"application/json");
        HttpResponse resp = req.execute();
        if (resp.getStatusCode() != 201) {
            throw new IOException(String.format(Locale.ROOT, "bad response from rekor @ '%s' : %s", rekorPutEndpoint, resp.parseAsString()));
        }
        String respEntryJson = resp.parseAsString();
        return RekorEntry.fromTLogEntryJson(respEntryJson);
    }

    public static class Builder {
        private HttpParams httpParams = ImmutableHttpParams.builder().build();
        private Service service;

        private Builder() {
        }

        public Builder setHttpParams(HttpParams httpParams) {
            this.httpParams = httpParams;
            return this;
        }

        public Builder setService(Service service) {
            this.service = service;
            return this;
        }

        public RekorV2ClientHttp build() {
            Preconditions.checkNotNull((Object)this.service);
            return new RekorV2ClientHttp(this.httpParams, this.service.getUrl());
        }
    }
}

