/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.timestamp.client;

import dev.sigstore.timestamp.client.UnsupportedHashAlgorithmException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.tsp.TSPAlgorithms;

public enum HashAlgorithm {
    SHA256("SHA256", TSPAlgorithms.SHA256),
    SHA384("SHA384", TSPAlgorithms.SHA384),
    SHA512("SHA512", TSPAlgorithms.SHA512);

    private final String algorithmName;
    private final ASN1ObjectIdentifier oid;

    private HashAlgorithm(String algorithmName, ASN1ObjectIdentifier oid) {
        this.algorithmName = algorithmName;
        this.oid = oid;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public ASN1ObjectIdentifier getOid() {
        return this.oid;
    }

    public static HashAlgorithm from(ASN1ObjectIdentifier oid) throws UnsupportedHashAlgorithmException {
        for (HashAlgorithm value : HashAlgorithm.values()) {
            if (!value.getOid().equals((ASN1Primitive)oid)) continue;
            return value;
        }
        throw new UnsupportedHashAlgorithmException(oid.getId());
    }
}

