/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.timestamp.client;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.timestamp.client.HashAlgorithm;
import dev.sigstore.timestamp.client.TimestampRequest;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TimestampRequest", generator="Immutables")
@Immutable
public final class ImmutableTimestampRequest
implements TimestampRequest {
    private final HashAlgorithm hashAlgorithm;
    private final byte[] hash;
    private final BigInteger nonce;
    private final Boolean requestCertificates;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTimestampRequest(Builder builder) {
        this.hashAlgorithm = builder.hashAlgorithm;
        this.hash = builder.hash;
        if (builder.nonce != null) {
            this.initShim.nonce(builder.nonce);
        }
        if (builder.requestCertificates != null) {
            this.initShim.requestCertificates(builder.requestCertificates);
        }
        this.nonce = this.initShim.getNonce();
        this.requestCertificates = this.initShim.requestCertificates();
        this.initShim = null;
    }

    private ImmutableTimestampRequest(HashAlgorithm hashAlgorithm, byte[] hash, BigInteger nonce, Boolean requestCertificates) {
        this.hashAlgorithm = hashAlgorithm;
        this.hash = hash;
        this.nonce = nonce;
        this.requestCertificates = requestCertificates;
        this.initShim = null;
    }

    private BigInteger getNonceInitialize() {
        return TimestampRequest.super.getNonce();
    }

    private Boolean requestCertificatesInitialize() {
        return TimestampRequest.super.requestCertificates();
    }

    @Override
    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    @Override
    public BigInteger getNonce() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getNonce() : this.nonce;
    }

    @Override
    public Boolean requestCertificates() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requestCertificates() : this.requestCertificates;
    }

    public final ImmutableTimestampRequest withHashAlgorithm(HashAlgorithm value) {
        HashAlgorithm newValue = Objects.requireNonNull(value, "hashAlgorithm");
        if (this.hashAlgorithm == newValue) {
            return this;
        }
        return new ImmutableTimestampRequest(newValue, this.hash, this.nonce, this.requestCertificates);
    }

    public final ImmutableTimestampRequest withHash(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableTimestampRequest(this.hashAlgorithm, newValue, this.nonce, this.requestCertificates);
    }

    public final ImmutableTimestampRequest withNonce(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "nonce");
        if (this.nonce.equals(newValue)) {
            return this;
        }
        return new ImmutableTimestampRequest(this.hashAlgorithm, this.hash, newValue, this.requestCertificates);
    }

    public final ImmutableTimestampRequest withRequestCertificates(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "requestCertificates");
        if (this.requestCertificates.equals(newValue)) {
            return this;
        }
        return new ImmutableTimestampRequest(this.hashAlgorithm, this.hash, this.nonce, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTimestampRequest && this.equalTo(0, (ImmutableTimestampRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableTimestampRequest another) {
        return this.hashAlgorithm.equals((Object)another.hashAlgorithm) && Arrays.equals(this.hash, another.hash) && this.nonce.equals(another.nonce) && this.requestCertificates.equals(another.requestCertificates);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hashAlgorithm.hashCode();
        h += (h << 5) + Arrays.hashCode(this.hash);
        h += (h << 5) + this.nonce.hashCode();
        h += (h << 5) + this.requestCertificates.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TimestampRequest").omitNullValues().add("hashAlgorithm", (Object)this.hashAlgorithm).add("hash", (Object)Arrays.toString(this.hash)).add("nonce", (Object)this.nonce).add("requestCertificates", (Object)this.requestCertificates).toString();
    }

    public static ImmutableTimestampRequest copyOf(TimestampRequest instance) {
        if (instance instanceof ImmutableTimestampRequest) {
            return (ImmutableTimestampRequest)instance;
        }
        return ImmutableTimestampRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TimestampRequest", generator="Immutables")
    private final class InitShim {
        private byte nonceBuildStage = 0;
        private BigInteger nonce;
        private byte requestCertificatesBuildStage = 0;
        private Boolean requestCertificates;

        private InitShim() {
        }

        BigInteger getNonce() {
            if (this.nonceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nonceBuildStage == 0) {
                this.nonceBuildStage = (byte)-1;
                this.nonce = Objects.requireNonNull(ImmutableTimestampRequest.this.getNonceInitialize(), "nonce");
                this.nonceBuildStage = 1;
            }
            return this.nonce;
        }

        void nonce(BigInteger nonce) {
            this.nonce = nonce;
            this.nonceBuildStage = 1;
        }

        Boolean requestCertificates() {
            if (this.requestCertificatesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestCertificatesBuildStage == 0) {
                this.requestCertificatesBuildStage = (byte)-1;
                this.requestCertificates = Objects.requireNonNull(ImmutableTimestampRequest.this.requestCertificatesInitialize(), "requestCertificates");
                this.requestCertificatesBuildStage = 1;
            }
            return this.requestCertificates;
        }

        void requestCertificates(Boolean requestCertificates) {
            this.requestCertificates = requestCertificates;
            this.requestCertificatesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.nonceBuildStage == -1) {
                attributes.add("nonce");
            }
            if (this.requestCertificatesBuildStage == -1) {
                attributes.add("requestCertificates");
            }
            return "Cannot build TimestampRequest, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="TimestampRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HASH_ALGORITHM = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private long initBits = 3L;
        @Nullable
        private HashAlgorithm hashAlgorithm;
        @Nullable
        private byte[] hash;
        @Nullable
        private BigInteger nonce;
        @Nullable
        private Boolean requestCertificates;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TimestampRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.hashAlgorithm(instance.getHashAlgorithm());
            this.hash(instance.getHash());
            this.nonce(instance.getNonce());
            this.requestCertificates(instance.requestCertificates());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hashAlgorithm(HashAlgorithm hashAlgorithm) {
            this.hashAlgorithm = Objects.requireNonNull(hashAlgorithm, "hashAlgorithm");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(byte ... hash) {
            this.hash = (byte[])hash.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nonce(BigInteger nonce) {
            this.nonce = Objects.requireNonNull(nonce, "nonce");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder requestCertificates(Boolean requestCertificates) {
            this.requestCertificates = Objects.requireNonNull(requestCertificates, "requestCertificates");
            return this;
        }

        public ImmutableTimestampRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTimestampRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hashAlgorithm");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build TimestampRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

