/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.timestamp.client;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.timestamp.client.TimestampException;
import dev.sigstore.timestamp.client.TimestampResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TimestampResponse", generator="Immutables")
@Immutable
public final class ImmutableTimestampResponse
implements TimestampResponse {
    private final byte[] encoded;
    private volatile transient long lazyInitBitmap;
    private static final long GEN_TIME_LAZY_INIT_BIT = 1L;
    private transient Date genTime;

    private ImmutableTimestampResponse(byte[] encoded) {
        this.encoded = encoded;
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public final ImmutableTimestampResponse withEncoded(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableTimestampResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTimestampResponse && this.equalTo(0, (ImmutableTimestampResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableTimestampResponse another) {
        return Arrays.equals(this.encoded, another.encoded);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.encoded);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TimestampResponse").omitNullValues().add("encoded", (Object)Arrays.toString(this.encoded)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getGenTime() throws TimestampException {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableTimestampResponse immutableTimestampResponse = this;
            synchronized (immutableTimestampResponse) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.genTime = Objects.requireNonNull(TimestampResponse.super.getGenTime(), "genTime");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.genTime;
    }

    public static ImmutableTimestampResponse copyOf(TimestampResponse instance) {
        if (instance instanceof ImmutableTimestampResponse) {
            return (ImmutableTimestampResponse)instance;
        }
        return ImmutableTimestampResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TimestampResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENCODED = 1L;
        private long initBits = 1L;
        @Nullable
        private byte[] encoded;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TimestampResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.encoded(instance.getEncoded());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder encoded(byte ... encoded) {
            this.encoded = (byte[])encoded.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableTimestampResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTimestampResponse(this.encoded);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("encoded");
            }
            return "Cannot build TimestampResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

