/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.timestamp.client;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.Preconditions;
import com.google.common.annotations.VisibleForTesting;
import dev.sigstore.http.HttpClients;
import dev.sigstore.http.HttpParams;
import dev.sigstore.timestamp.client.ImmutableTimestampResponse;
import dev.sigstore.timestamp.client.TimestampClient;
import dev.sigstore.timestamp.client.TimestampException;
import dev.sigstore.timestamp.client.TimestampRequest;
import dev.sigstore.timestamp.client.TimestampResponse;
import dev.sigstore.trustroot.Service;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.util.Locale;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;

public class TimestampClientHttp
implements TimestampClient {
    private static final String CONTENT_TYPE_TIMESTAMP_QUERY = "application/timestamp-query";
    private static final String ACCEPT_TYPE_TIMESTAMP_REPLY = "application/timestamp-reply";
    private final HttpRequestFactory requestFactory;
    private final URI uri;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    TimestampClientHttp(HttpRequestFactory requestFactory, URI uri) {
        this.requestFactory = requestFactory;
        this.uri = uri;
    }

    @Override
    public TimestampResponse timestamp(TimestampRequest tsReq) throws TimestampException {
        ImmutableTimestampResponse tsResp;
        HttpResponse httpTsResp;
        TimeStampRequest bcTsReq;
        TimeStampRequestGenerator bcTsReqGen = new TimeStampRequestGenerator();
        ASN1ObjectIdentifier bcAlgorithmOid = tsReq.getHashAlgorithm().getOid();
        byte[] artifactHashBytes = tsReq.getHash();
        BigInteger nonce = tsReq.getNonce();
        bcTsReqGen.setCertReq(tsReq.requestCertificates().booleanValue());
        try {
            bcTsReq = bcTsReqGen.generate(bcAlgorithmOid, artifactHashBytes, nonce);
            byte[] requestBytes = bcTsReq.getEncoded();
            httpTsResp = this.sendTimestampRequest(this.uri, requestBytes);
        }
        catch (IOException e) {
            throw new TimestampException("Timestamp request failed: " + e.getMessage(), e);
        }
        try {
            TimeStampResponse bcTsResp = this.getBcTimestampResponse(httpTsResp, bcTsReq);
            byte[] tsRespBytes = bcTsResp.getEncoded();
            tsResp = ImmutableTimestampResponse.builder().encoded(tsRespBytes).build();
        }
        catch (IOException | TSPException e) {
            throw new TimestampException("Timestamp response validation or parsing failed: " + e.getMessage(), e);
        }
        return tsResp;
    }

    HttpResponse sendTimestampRequest(URI tsaUri, byte[] requestBytes) throws IOException {
        Objects.requireNonNull(tsaUri, "tsaUri cannot be null");
        Objects.requireNonNull(requestBytes, "requestBytes cannot be null");
        HttpRequest httpReq = this.requestFactory.buildPostRequest(new GenericUrl(tsaUri), (HttpContent)new ByteArrayContent(CONTENT_TYPE_TIMESTAMP_QUERY, requestBytes));
        httpReq.getHeaders().setAccept(ACCEPT_TYPE_TIMESTAMP_REPLY);
        httpReq.setThrowExceptionOnExecuteError(false);
        httpReq.setNumberOfRetries(5);
        HttpResponse httpResp = httpReq.execute();
        if (httpResp.getStatusCode() < 200 || httpResp.getStatusCode() >= 300) {
            throw new IOException(String.format(Locale.ROOT, "bad response from timestamp @ '%s' : %s", tsaUri, httpResp.parseAsString()));
        }
        return httpResp;
    }

    private TimeStampResponse getBcTimestampResponse(HttpResponse httpTsResp, TimeStampRequest bcTsReq) throws IOException, TSPException {
        Objects.requireNonNull(httpTsResp, "HttpResponse cannot be null");
        Objects.requireNonNull(bcTsReq, "TimeStampRequest cannot be null");
        TimeStampResponse bcTsResp = new TimeStampResponse(httpTsResp.getContent());
        bcTsResp.validate(bcTsReq);
        return bcTsResp;
    }

    public static class Builder {
        private HttpParams httpParams = HttpParams.builder().build();
        private Service service;

        private Builder() {
        }

        public Builder setHttpParams(HttpParams httpParams) {
            this.httpParams = httpParams;
            return this;
        }

        public Builder setService(Service service) {
            this.service = service;
            return this;
        }

        public TimestampClientHttp build() throws IOException {
            Preconditions.checkNotNull((Object)this.service);
            HttpRequestFactory requestFactory = HttpClients.newRequestFactory(this.httpParams);
            return new TimestampClientHttp(requestFactory, this.service.getUrl());
        }
    }
}

