/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.trustroot.CertificateAuthority;
import dev.sigstore.trustroot.Subject;
import dev.sigstore.trustroot.ValidFor;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CertificateAuthority", generator="Immutables")
@Immutable
public final class ImmutableCertificateAuthority
extends CertificateAuthority {
    private final CertPath certPath;
    private final URI uri;
    private final ValidFor validFor;
    private final Subject subject;
    private volatile transient long lazyInitBitmap;
    private static final long AS_TRUST_ANCHOR_LAZY_INIT_BIT = 1L;
    private transient TrustAnchor asTrustAnchor;

    private ImmutableCertificateAuthority(CertPath certPath, URI uri, ValidFor validFor, Subject subject) {
        this.certPath = certPath;
        this.uri = uri;
        this.validFor = validFor;
        this.subject = subject;
    }

    @Override
    public CertPath getCertPath() {
        return this.certPath;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public ValidFor getValidFor() {
        return this.validFor;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    public final ImmutableCertificateAuthority withCertPath(CertPath value) {
        if (this.certPath == value) {
            return this;
        }
        CertPath newValue = Objects.requireNonNull(value, "certPath");
        return new ImmutableCertificateAuthority(newValue, this.uri, this.validFor, this.subject);
    }

    public final ImmutableCertificateAuthority withUri(URI value) {
        if (this.uri == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "uri");
        return new ImmutableCertificateAuthority(this.certPath, newValue, this.validFor, this.subject);
    }

    public final ImmutableCertificateAuthority withValidFor(ValidFor value) {
        if (this.validFor == value) {
            return this;
        }
        ValidFor newValue = Objects.requireNonNull(value, "validFor");
        return new ImmutableCertificateAuthority(this.certPath, this.uri, newValue, this.subject);
    }

    public final ImmutableCertificateAuthority withSubject(Subject value) {
        if (this.subject == value) {
            return this;
        }
        Subject newValue = Objects.requireNonNull(value, "subject");
        return new ImmutableCertificateAuthority(this.certPath, this.uri, this.validFor, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCertificateAuthority && this.equalTo(0, (ImmutableCertificateAuthority)another);
    }

    private boolean equalTo(int synthetic, ImmutableCertificateAuthority another) {
        return this.certPath.equals(another.certPath) && this.uri.equals(another.uri) && this.validFor.equals(another.validFor) && this.subject.equals(another.subject);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.certPath.hashCode();
        h += (h << 5) + this.uri.hashCode();
        h += (h << 5) + this.validFor.hashCode();
        h += (h << 5) + this.subject.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CertificateAuthority").omitNullValues().add("certPath", (Object)this.certPath).add("uri", (Object)this.uri).add("validFor", (Object)this.validFor).add("subject", (Object)this.subject).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrustAnchor asTrustAnchor() throws CertificateException, InvalidAlgorithmParameterException {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableCertificateAuthority immutableCertificateAuthority = this;
            synchronized (immutableCertificateAuthority) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.asTrustAnchor = Objects.requireNonNull(super.asTrustAnchor(), "asTrustAnchor");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.asTrustAnchor;
    }

    public static ImmutableCertificateAuthority copyOf(CertificateAuthority instance) {
        if (instance instanceof ImmutableCertificateAuthority) {
            return (ImmutableCertificateAuthority)instance;
        }
        return ImmutableCertificateAuthority.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CertificateAuthority", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CERT_PATH = 1L;
        private static final long INIT_BIT_URI = 2L;
        private static final long INIT_BIT_VALID_FOR = 4L;
        private static final long INIT_BIT_SUBJECT = 8L;
        private long initBits = 15L;
        @Nullable
        private CertPath certPath;
        @Nullable
        private URI uri;
        @Nullable
        private ValidFor validFor;
        @Nullable
        private Subject subject;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CertificateAuthority instance) {
            Objects.requireNonNull(instance, "instance");
            this.certPath(instance.getCertPath());
            this.uri(instance.getUri());
            this.validFor(instance.getValidFor());
            this.subject(instance.getSubject());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder certPath(CertPath certPath) {
            this.certPath = Objects.requireNonNull(certPath, "certPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(URI uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validFor(ValidFor validFor) {
            this.validFor = Objects.requireNonNull(validFor, "validFor");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subject(Subject subject) {
            this.subject = Objects.requireNonNull(subject, "subject");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableCertificateAuthority build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCertificateAuthority(this.certPath, this.uri, this.validFor, this.subject);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("certPath");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("uri");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("validFor");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("subject");
            }
            return "Cannot build CertificateAuthority, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

