/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.trustroot.Service;
import java.util.ArrayList;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Service.Config", generator="Immutables")
@Immutable
public final class ImmutableConfig
implements Service.Config {
    @Nullable
    private final Integer count;
    private final Service.Config.Selector selector;

    private ImmutableConfig(@Nullable Integer count, Service.Config.Selector selector) {
        this.count = count;
        this.selector = selector;
    }

    @Override
    public OptionalInt getCount() {
        return this.count != null ? OptionalInt.of(this.count) : OptionalInt.empty();
    }

    @Override
    public Service.Config.Selector getSelector() {
        return this.selector;
    }

    public final ImmutableConfig withCount(int value) {
        Integer newValue = value;
        if (Objects.equals(this.count, newValue)) {
            return this;
        }
        return new ImmutableConfig(newValue, this.selector);
    }

    public final ImmutableConfig withCount(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.count, value)) {
            return this;
        }
        return new ImmutableConfig(value, this.selector);
    }

    public final ImmutableConfig withSelector(Service.Config.Selector value) {
        Service.Config.Selector newValue = Objects.requireNonNull(value, "selector");
        if (this.selector == newValue) {
            return this;
        }
        return new ImmutableConfig(this.count, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfig && this.equalTo(0, (ImmutableConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableConfig another) {
        return Objects.equals(this.count, another.count) && this.selector.equals((Object)another.selector);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.count);
        h += (h << 5) + this.selector.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Config").omitNullValues().add("count", (Object)this.count).add("selector", (Object)this.selector).toString();
    }

    public static ImmutableConfig copyOf(Service.Config instance) {
        if (instance instanceof ImmutableConfig) {
            return (ImmutableConfig)instance;
        }
        return ImmutableConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Service.Config", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SELECTOR = 1L;
        private long initBits = 1L;
        @Nullable
        private Integer count;
        @Nullable
        private Service.Config.Selector selector;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Service.Config instance) {
            Objects.requireNonNull(instance, "instance");
            OptionalInt countOptional = instance.getCount();
            if (countOptional.isPresent()) {
                this.count(countOptional);
            }
            this.selector(instance.getSelector());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder count(int count) {
            this.count = count;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder count(OptionalInt count) {
            this.count = count.isPresent() ? Integer.valueOf(count.getAsInt()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder selector(Service.Config.Selector selector) {
            this.selector = Objects.requireNonNull(selector, "selector");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfig(this.count, this.selector);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("selector");
            }
            return "Cannot build Config, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

