/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.trustroot.LogId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LogId", generator="Immutables")
@Immutable
public final class ImmutableLogId
implements LogId {
    private final byte[] keyId;

    private ImmutableLogId(byte[] keyId) {
        this.keyId = keyId;
    }

    @Override
    public byte[] getKeyId() {
        return (byte[])this.keyId.clone();
    }

    public final ImmutableLogId withKeyId(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableLogId(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLogId && this.equalTo(0, (ImmutableLogId)another);
    }

    private boolean equalTo(int synthetic, ImmutableLogId another) {
        return Arrays.equals(this.keyId, another.keyId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.keyId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LogId").omitNullValues().add("keyId", (Object)Arrays.toString(this.keyId)).toString();
    }

    public static ImmutableLogId copyOf(LogId instance) {
        if (instance instanceof ImmutableLogId) {
            return (ImmutableLogId)instance;
        }
        return ImmutableLogId.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LogId", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private byte[] keyId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LogId instance) {
            Objects.requireNonNull(instance, "instance");
            this.keyId(instance.getKeyId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyId(byte ... keyId) {
            this.keyId = (byte[])keyId.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableLogId build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLogId(this.keyId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("keyId");
            }
            return "Cannot build LogId, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

