/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.trustroot.Service;
import dev.sigstore.trustroot.ValidFor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Service", generator="Immutables")
@Immutable
public final class ImmutableService
implements Service {
    private final URI url;
    private final int apiVersion;
    private final ValidFor validFor;

    private ImmutableService(URI url, int apiVersion, ValidFor validFor) {
        this.url = url;
        this.apiVersion = apiVersion;
        this.validFor = validFor;
    }

    @Override
    public URI getUrl() {
        return this.url;
    }

    @Override
    public int getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public ValidFor getValidFor() {
        return this.validFor;
    }

    public final ImmutableService withUrl(URI value) {
        if (this.url == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "url");
        return new ImmutableService(newValue, this.apiVersion, this.validFor);
    }

    public final ImmutableService withApiVersion(int value) {
        if (this.apiVersion == value) {
            return this;
        }
        return new ImmutableService(this.url, value, this.validFor);
    }

    public final ImmutableService withValidFor(ValidFor value) {
        if (this.validFor == value) {
            return this;
        }
        ValidFor newValue = Objects.requireNonNull(value, "validFor");
        return new ImmutableService(this.url, this.apiVersion, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableService && this.equalTo(0, (ImmutableService)another);
    }

    private boolean equalTo(int synthetic, ImmutableService another) {
        return this.url.equals(another.url) && this.apiVersion == another.apiVersion && this.validFor.equals(another.validFor);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.apiVersion;
        h += (h << 5) + this.validFor.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Service").omitNullValues().add("url", (Object)this.url).add("apiVersion", this.apiVersion).add("validFor", (Object)this.validFor).toString();
    }

    public static ImmutableService copyOf(Service instance) {
        if (instance instanceof ImmutableService) {
            return (ImmutableService)instance;
        }
        return ImmutableService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Service", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_API_VERSION = 2L;
        private static final long INIT_BIT_VALID_FOR = 4L;
        private long initBits = 7L;
        @Nullable
        private URI url;
        private int apiVersion;
        @Nullable
        private ValidFor validFor;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Service instance) {
            Objects.requireNonNull(instance, "instance");
            this.url(instance.getUrl());
            this.apiVersion(instance.getApiVersion());
            this.validFor(instance.getValidFor());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder url(URI url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder apiVersion(int apiVersion) {
            this.apiVersion = apiVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validFor(ValidFor validFor) {
            this.validFor = Objects.requireNonNull(validFor, "validFor");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableService(this.url, this.apiVersion, this.validFor);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("apiVersion");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("validFor");
            }
            return "Cannot build Service, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

