/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.trustroot.Service;
import dev.sigstore.trustroot.SigstoreSigningConfig;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SigstoreSigningConfig", generator="Immutables")
@Immutable
public final class ImmutableSigstoreSigningConfig
implements SigstoreSigningConfig {
    private final ImmutableList<Service> cas;
    private final ImmutableList<Service> tsas;
    private final ImmutableList<Service> tLogs;
    private final ImmutableList<Service> oidcProviders;
    private final Service.Config tsaConfig;
    private final Service.Config tLogConfig;

    private ImmutableSigstoreSigningConfig(ImmutableList<Service> cas, ImmutableList<Service> tsas, ImmutableList<Service> tLogs, ImmutableList<Service> oidcProviders, Service.Config tsaConfig, Service.Config tLogConfig) {
        this.cas = cas;
        this.tsas = tsas;
        this.tLogs = tLogs;
        this.oidcProviders = oidcProviders;
        this.tsaConfig = tsaConfig;
        this.tLogConfig = tLogConfig;
    }

    public ImmutableList<Service> getCas() {
        return this.cas;
    }

    public ImmutableList<Service> getTsas() {
        return this.tsas;
    }

    public ImmutableList<Service> getTLogs() {
        return this.tLogs;
    }

    public ImmutableList<Service> getOidcProviders() {
        return this.oidcProviders;
    }

    @Override
    public Service.Config getTsaConfig() {
        return this.tsaConfig;
    }

    @Override
    public Service.Config getTLogConfig() {
        return this.tLogConfig;
    }

    public final ImmutableSigstoreSigningConfig withCas(Service ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSigstoreSigningConfig((ImmutableList<Service>)newValue, this.tsas, this.tLogs, this.oidcProviders, this.tsaConfig, this.tLogConfig);
    }

    public final ImmutableSigstoreSigningConfig withCas(Iterable<? extends Service> elements) {
        if (this.cas == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSigstoreSigningConfig((ImmutableList<Service>)newValue, this.tsas, this.tLogs, this.oidcProviders, this.tsaConfig, this.tLogConfig);
    }

    public final ImmutableSigstoreSigningConfig withTsas(Service ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSigstoreSigningConfig(this.cas, (ImmutableList<Service>)newValue, this.tLogs, this.oidcProviders, this.tsaConfig, this.tLogConfig);
    }

    public final ImmutableSigstoreSigningConfig withTsas(Iterable<? extends Service> elements) {
        if (this.tsas == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSigstoreSigningConfig(this.cas, (ImmutableList<Service>)newValue, this.tLogs, this.oidcProviders, this.tsaConfig, this.tLogConfig);
    }

    public final ImmutableSigstoreSigningConfig withTLogs(Service ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSigstoreSigningConfig(this.cas, this.tsas, (ImmutableList<Service>)newValue, this.oidcProviders, this.tsaConfig, this.tLogConfig);
    }

    public final ImmutableSigstoreSigningConfig withTLogs(Iterable<? extends Service> elements) {
        if (this.tLogs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSigstoreSigningConfig(this.cas, this.tsas, (ImmutableList<Service>)newValue, this.oidcProviders, this.tsaConfig, this.tLogConfig);
    }

    public final ImmutableSigstoreSigningConfig withOidcProviders(Service ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSigstoreSigningConfig(this.cas, this.tsas, this.tLogs, (ImmutableList<Service>)newValue, this.tsaConfig, this.tLogConfig);
    }

    public final ImmutableSigstoreSigningConfig withOidcProviders(Iterable<? extends Service> elements) {
        if (this.oidcProviders == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSigstoreSigningConfig(this.cas, this.tsas, this.tLogs, (ImmutableList<Service>)newValue, this.tsaConfig, this.tLogConfig);
    }

    public final ImmutableSigstoreSigningConfig withTsaConfig(Service.Config value) {
        if (this.tsaConfig == value) {
            return this;
        }
        Service.Config newValue = Objects.requireNonNull(value, "tsaConfig");
        return new ImmutableSigstoreSigningConfig(this.cas, this.tsas, this.tLogs, this.oidcProviders, newValue, this.tLogConfig);
    }

    public final ImmutableSigstoreSigningConfig withTLogConfig(Service.Config value) {
        if (this.tLogConfig == value) {
            return this;
        }
        Service.Config newValue = Objects.requireNonNull(value, "tLogConfig");
        return new ImmutableSigstoreSigningConfig(this.cas, this.tsas, this.tLogs, this.oidcProviders, this.tsaConfig, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSigstoreSigningConfig && this.equalTo(0, (ImmutableSigstoreSigningConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableSigstoreSigningConfig another) {
        return this.cas.equals(another.cas) && this.tsas.equals(another.tsas) && this.tLogs.equals(another.tLogs) && this.oidcProviders.equals(another.oidcProviders) && this.tsaConfig.equals(another.tsaConfig) && this.tLogConfig.equals(another.tLogConfig);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.cas.hashCode();
        h += (h << 5) + this.tsas.hashCode();
        h += (h << 5) + this.tLogs.hashCode();
        h += (h << 5) + this.oidcProviders.hashCode();
        h += (h << 5) + this.tsaConfig.hashCode();
        h += (h << 5) + this.tLogConfig.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SigstoreSigningConfig").omitNullValues().add("cas", this.cas).add("tsas", this.tsas).add("tLogs", this.tLogs).add("oidcProviders", this.oidcProviders).add("tsaConfig", (Object)this.tsaConfig).add("tLogConfig", (Object)this.tLogConfig).toString();
    }

    public static ImmutableSigstoreSigningConfig copyOf(SigstoreSigningConfig instance) {
        if (instance instanceof ImmutableSigstoreSigningConfig) {
            return (ImmutableSigstoreSigningConfig)instance;
        }
        return ImmutableSigstoreSigningConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SigstoreSigningConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TSA_CONFIG = 1L;
        private static final long INIT_BIT_T_LOG_CONFIG = 2L;
        private long initBits = 3L;
        private ImmutableList.Builder<Service> cas = ImmutableList.builder();
        private ImmutableList.Builder<Service> tsas = ImmutableList.builder();
        private ImmutableList.Builder<Service> tLogs = ImmutableList.builder();
        private ImmutableList.Builder<Service> oidcProviders = ImmutableList.builder();
        @Nullable
        private Service.Config tsaConfig;
        @Nullable
        private Service.Config tLogConfig;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SigstoreSigningConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCas(instance.getCas());
            this.addAllTsas(instance.getTsas());
            this.addAllTLogs(instance.getTLogs());
            this.addAllOidcProviders(instance.getOidcProviders());
            this.tsaConfig(instance.getTsaConfig());
            this.tLogConfig(instance.getTLogConfig());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCas(Service element) {
            this.cas.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCas(Service ... elements) {
            this.cas.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cas(Iterable<? extends Service> elements) {
            this.cas = ImmutableList.builder();
            return this.addAllCas(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCas(Iterable<? extends Service> elements) {
            this.cas.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTsas(Service element) {
            this.tsas.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTsas(Service ... elements) {
            this.tsas.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tsas(Iterable<? extends Service> elements) {
            this.tsas = ImmutableList.builder();
            return this.addAllTsas(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTsas(Iterable<? extends Service> elements) {
            this.tsas.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTLogs(Service element) {
            this.tLogs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTLogs(Service ... elements) {
            this.tLogs.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tLogs(Iterable<? extends Service> elements) {
            this.tLogs = ImmutableList.builder();
            return this.addAllTLogs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTLogs(Iterable<? extends Service> elements) {
            this.tLogs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOidcProviders(Service element) {
            this.oidcProviders.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOidcProviders(Service ... elements) {
            this.oidcProviders.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder oidcProviders(Iterable<? extends Service> elements) {
            this.oidcProviders = ImmutableList.builder();
            return this.addAllOidcProviders(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllOidcProviders(Iterable<? extends Service> elements) {
            this.oidcProviders.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tsaConfig(Service.Config tsaConfig) {
            this.tsaConfig = Objects.requireNonNull(tsaConfig, "tsaConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tLogConfig(Service.Config tLogConfig) {
            this.tLogConfig = Objects.requireNonNull(tLogConfig, "tLogConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSigstoreSigningConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSigstoreSigningConfig((ImmutableList<Service>)this.cas.build(), (ImmutableList<Service>)this.tsas.build(), (ImmutableList<Service>)this.tLogs.build(), (ImmutableList<Service>)this.oidcProviders.build(), this.tsaConfig, this.tLogConfig);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tsaConfig");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tLogConfig");
            }
            return "Cannot build SigstoreSigningConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

