/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.trustroot.Subject;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Subject", generator="Immutables")
@Immutable
public final class ImmutableSubject
implements Subject {
    private final String organization;
    private final String commonName;

    private ImmutableSubject(String organization, String commonName) {
        this.organization = organization;
        this.commonName = commonName;
    }

    @Override
    public String getOrganization() {
        return this.organization;
    }

    @Override
    public String getCommonName() {
        return this.commonName;
    }

    public final ImmutableSubject withOrganization(String value) {
        String newValue = Objects.requireNonNull(value, "organization");
        if (this.organization.equals(newValue)) {
            return this;
        }
        return new ImmutableSubject(newValue, this.commonName);
    }

    public final ImmutableSubject withCommonName(String value) {
        String newValue = Objects.requireNonNull(value, "commonName");
        if (this.commonName.equals(newValue)) {
            return this;
        }
        return new ImmutableSubject(this.organization, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubject && this.equalTo(0, (ImmutableSubject)another);
    }

    private boolean equalTo(int synthetic, ImmutableSubject another) {
        return this.organization.equals(another.organization) && this.commonName.equals(another.commonName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.organization.hashCode();
        h += (h << 5) + this.commonName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Subject").omitNullValues().add("organization", (Object)this.organization).add("commonName", (Object)this.commonName).toString();
    }

    public static ImmutableSubject copyOf(Subject instance) {
        if (instance instanceof ImmutableSubject) {
            return (ImmutableSubject)instance;
        }
        return ImmutableSubject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Subject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION = 1L;
        private static final long INIT_BIT_COMMON_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String organization;
        @Nullable
        private String commonName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Subject instance) {
            Objects.requireNonNull(instance, "instance");
            this.organization(instance.getOrganization());
            this.commonName(instance.getCommonName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder organization(String organization) {
            this.organization = Objects.requireNonNull(organization, "organization");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commonName(String commonName) {
            this.commonName = Objects.requireNonNull(commonName, "commonName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSubject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubject(this.organization, this.commonName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organization");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commonName");
            }
            return "Cannot build Subject, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

