/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.trustroot.ValidFor;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ValidFor", generator="Immutables")
@Immutable
public final class ImmutableValidFor
extends ValidFor {
    private final Instant start;
    @Nullable
    private final Instant end;

    private ImmutableValidFor(Instant start, @Nullable Instant end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public Instant getStart() {
        return this.start;
    }

    @Override
    public Optional<Instant> getEnd() {
        return Optional.ofNullable(this.end);
    }

    public final ImmutableValidFor withStart(Instant value) {
        if (this.start == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "start");
        return new ImmutableValidFor(newValue, this.end);
    }

    public final ImmutableValidFor withEnd(Instant value) {
        Instant newValue = Objects.requireNonNull(value, "end");
        if (this.end == newValue) {
            return this;
        }
        return new ImmutableValidFor(this.start, newValue);
    }

    public final ImmutableValidFor withEnd(Optional<? extends Instant> optional) {
        Instant value = optional.orElse(null);
        if (this.end == value) {
            return this;
        }
        return new ImmutableValidFor(this.start, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValidFor && this.equalTo(0, (ImmutableValidFor)another);
    }

    private boolean equalTo(int synthetic, ImmutableValidFor another) {
        return this.start.equals(another.start) && Objects.equals(this.end, another.end);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.start.hashCode();
        h += (h << 5) + Objects.hashCode(this.end);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValidFor").omitNullValues().add("start", (Object)this.start).add("end", (Object)this.end).toString();
    }

    public static ImmutableValidFor copyOf(ValidFor instance) {
        if (instance instanceof ImmutableValidFor) {
            return (ImmutableValidFor)instance;
        }
        return ImmutableValidFor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ValidFor", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_START = 1L;
        private long initBits = 1L;
        @Nullable
        private Instant start;
        @Nullable
        private Instant end;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ValidFor instance) {
            Objects.requireNonNull(instance, "instance");
            this.start(instance.getStart());
            Optional<Instant> endOptional = instance.getEnd();
            if (endOptional.isPresent()) {
                this.end(endOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder start(Instant start) {
            this.start = Objects.requireNonNull(start, "start");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder end(Instant end) {
            this.end = Objects.requireNonNull(end, "end");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder end(Optional<? extends Instant> end) {
            this.end = end.orElse(null);
            return this;
        }

        public ImmutableValidFor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValidFor(this.start, this.end);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("start");
            }
            return "Cannot build ValidFor, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

