/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import dev.sigstore.encryption.Keys;
import dev.sigstore.trustroot.ImmutablePublicKey;
import dev.sigstore.trustroot.ValidFor;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PublicKey {
    public abstract byte[] getRawBytes();

    public abstract String getKeyDetails();

    public abstract ValidFor getValidFor();

    @Value.Lazy
    public java.security.PublicKey toJavaPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.getKeyDetails().equals("PKIX_ECDSA_P256_SHA_256")) {
            return Keys.parseEcdsa(this.getRawBytes());
        }
        if (this.getKeyDetails().startsWith("PKIX_RSA")) {
            return Keys.parseRsa(this.getRawBytes());
        }
        if (this.getKeyDetails().equals("PKCS1_RSA_PKCS1V5")) {
            return Keys.parseRsaPkcs1(this.getRawBytes());
        }
        if (this.getKeyDetails().equals("PKIX_ED25519")) {
            return Keys.parseEd25519(this.getRawBytes());
        }
        throw new InvalidKeySpecException("Unsupported key algorithm: " + this.getKeyDetails());
    }

    public static PublicKey from(dev.sigstore.proto.common.v1.PublicKey proto) {
        return ImmutablePublicKey.builder().rawBytes(proto.getRawBytes().toByteArray()).keyDetails(proto.getKeyDetails().name()).validFor(ValidFor.from(proto.getValidFor())).build();
    }
}

