/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import dev.sigstore.proto.trustroot.v1.ServiceConfiguration;
import dev.sigstore.trustroot.ImmutableConfig;
import dev.sigstore.trustroot.ImmutableService;
import dev.sigstore.trustroot.ImmutableValidFor;
import dev.sigstore.trustroot.SigstoreConfigurationException;
import dev.sigstore.trustroot.ValidFor;
import java.net.URI;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.immutables.value.Value;

@Value.Immutable
public interface Service {
    public URI getUrl();

    public int getApiVersion();

    public ValidFor getValidFor();

    public static Service from(dev.sigstore.proto.trustroot.v1.Service service) {
        return ImmutableService.builder().apiVersion(service.getMajorApiVersion()).validFor(ValidFor.from(service.getValidFor())).url(URI.create(service.getUrl())).build();
    }

    public static Service of(URI url, int apiVersion) {
        return ImmutableService.builder().apiVersion(apiVersion).validFor(ImmutableValidFor.builder().start(Instant.now()).build()).url(url).build();
    }

    public static Optional<Service> select(List<Service> services, List<Integer> apiVersions) {
        OptionalInt maxApiVersionMaybe = services.stream().mapToInt(Service::getApiVersion).filter(apiVersions::contains).max();
        if (maxApiVersionMaybe.isEmpty()) {
            return Optional.empty();
        }
        int maxApiVersion = maxApiVersionMaybe.getAsInt();
        return services.stream().filter(s -> s.getValidFor().contains(Instant.now())).filter(s -> s.getApiVersion() == maxApiVersion).max(Comparator.comparingLong(s -> s.getValidFor().getStart().toEpochMilli()));
    }

    @Value.Immutable
    public static interface Config {
        public OptionalInt getCount();

        public Selector getSelector();

        public static Config from(ServiceConfiguration config) throws SigstoreConfigurationException {
            switch (config.getSelector()) {
                case ANY: {
                    return ImmutableConfig.builder().selector(Selector.ANY).build();
                }
                case EXACT: {
                    return ImmutableConfig.builder().selector(Selector.EXACT).count(config.getCount()).build();
                }
                case ALL: {
                    return ImmutableConfig.builder().selector(Selector.ALL).build();
                }
            }
            throw new SigstoreConfigurationException("Cannot parse signing configuration selector: " + String.valueOf((Object)config.getSelector()));
        }

        public static Config ofAny() {
            return ImmutableConfig.builder().selector(Selector.ANY).build();
        }

        public static enum Selector {
            ANY,
            EXACT,
            ALL;

        }
    }
}

