/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.protobuf.Message;
import dev.sigstore.json.ProtoJson;
import dev.sigstore.proto.trustroot.v1.SigningConfig;
import dev.sigstore.trustroot.ImmutableSigstoreSigningConfig;
import dev.sigstore.trustroot.Service;
import dev.sigstore.trustroot.SigstoreConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public interface SigstoreSigningConfig {
    public static final String MEDIA_TYPE = "application/vnd.dev.sigstore.signingconfig.v0.2+json";

    public List<Service> getCas();

    public List<Service> getTsas();

    public List<Service> getTLogs();

    public List<Service> getOidcProviders();

    public Service.Config getTsaConfig();

    public Service.Config getTLogConfig();

    public static SigstoreSigningConfig from(SigningConfig proto) throws SigstoreConfigurationException {
        if (!proto.getMediaType().equals(MEDIA_TYPE)) {
            throw new SigstoreConfigurationException("Unsupported signing config mediaType: " + proto.getMediaType());
        }
        return ImmutableSigstoreSigningConfig.builder().addAllCas(SigstoreSigningConfig.protoToServiceList(proto.getCaUrlsList())).addAllTLogs(SigstoreSigningConfig.protoToServiceList(proto.getRekorTlogUrlsList())).addAllOidcProviders(SigstoreSigningConfig.protoToServiceList(proto.getOidcUrlsList())).addAllTsas(SigstoreSigningConfig.protoToServiceList(proto.getTsaUrlsList())).tsaConfig(Service.Config.from(proto.getTsaConfig())).tLogConfig(Service.Config.from(proto.getRekorTlogConfig())).build();
    }

    public static SigstoreSigningConfig from(InputStream json) throws SigstoreConfigurationException {
        SigningConfig.Builder signingConfigBuilder = SigningConfig.newBuilder();
        try (InputStreamReader reader = new InputStreamReader(json, StandardCharsets.UTF_8);){
            ProtoJson.parser().merge((Reader)reader, (Message.Builder)signingConfigBuilder);
        }
        catch (IOException ex) {
            throw new SigstoreConfigurationException("Could not parse signing configuration", ex);
        }
        return SigstoreSigningConfig.from(signingConfigBuilder.build());
    }

    private static List<Service> protoToServiceList(List<dev.sigstore.proto.trustroot.v1.Service> serviceList) {
        return serviceList.stream().map(Service::from).collect(Collectors.toList());
    }
}

