/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import com.google.api.client.util.Lists;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import dev.sigstore.json.ProtoJson;
import dev.sigstore.proto.trustroot.v1.TrustedRoot;
import dev.sigstore.proto.trustroot.v1.TrustedRootOrBuilder;
import dev.sigstore.trustroot.CertificateAuthority;
import dev.sigstore.trustroot.ImmutableSigstoreTrustedRoot;
import dev.sigstore.trustroot.SigstoreConfigurationException;
import dev.sigstore.trustroot.TransparencyLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public interface SigstoreTrustedRoot {
    public List<CertificateAuthority> getCAs();

    public List<TransparencyLog> getTLogs();

    public List<TransparencyLog> getCTLogs();

    public List<CertificateAuthority> getTSAs();

    public static SigstoreTrustedRoot from(InputStream json) throws SigstoreConfigurationException {
        TrustedRoot.Builder trustedRootBuilder = TrustedRoot.newBuilder();
        try (InputStreamReader reader = new InputStreamReader(json, StandardCharsets.UTF_8);){
            ProtoJson.parser().merge((Reader)reader, (Message.Builder)trustedRootBuilder);
        }
        catch (IOException ex) {
            throw new SigstoreConfigurationException("Could not parse trusted root", ex);
        }
        return SigstoreTrustedRoot.from(trustedRootBuilder);
    }

    public static SigstoreTrustedRoot from(TrustedRootOrBuilder proto) throws SigstoreConfigurationException {
        if (!Strings.isNullOrEmpty((String)proto.getMediaType()) && !proto.getMediaType().equals("application/vnd.dev.sigstore.trustedroot+json;version=0.1")) {
            throw new SigstoreConfigurationException("Unsupported trusted root mediaType: " + proto.getMediaType());
        }
        ArrayList cas = Lists.newArrayList();
        for (dev.sigstore.proto.trustroot.v1.CertificateAuthority certAuthority : proto.getCertificateAuthoritiesList()) {
            try {
                cas.add(CertificateAuthority.from(certAuthority));
            }
            catch (CertificateException ce) {
                throw new SigstoreConfigurationException("Could not parse certificate in trusted root", ce);
            }
        }
        List tlogs = proto.getTlogsList().stream().map(TransparencyLog::from).collect(Collectors.toList());
        List ctlogs = proto.getCtlogsList().stream().map(TransparencyLog::from).collect(Collectors.toList());
        ArrayList tsas = Lists.newArrayList();
        for (dev.sigstore.proto.trustroot.v1.CertificateAuthority timestampAuthority : proto.getTimestampAuthoritiesList()) {
            try {
                tsas.add(CertificateAuthority.from(timestampAuthority));
            }
            catch (CertificateException ce) {
                throw new SigstoreConfigurationException("Could not parse TSAs in trusted root", ce);
            }
        }
        return ImmutableSigstoreTrustedRoot.builder().cAs(cas).tLogs(tlogs).cTLogs(ctlogs).tSAs(tsas).build();
    }
}

