/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.trustroot;

import dev.sigstore.proto.trustroot.v1.TransparencyLogInstance;
import dev.sigstore.trustroot.ImmutableTransparencyLog;
import dev.sigstore.trustroot.LogId;
import dev.sigstore.trustroot.PublicKey;
import java.net.URI;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface TransparencyLog {
    public URI getBaseUrl();

    public String getHashAlgorithm();

    public LogId getLogId();

    public PublicKey getPublicKey();

    public static TransparencyLog from(TransparencyLogInstance proto) {
        return ImmutableTransparencyLog.builder().baseUrl(URI.create(proto.getBaseUrl())).hashAlgorithm(proto.getHashAlgorithm().name()).logId(LogId.from(proto.getLogId())).publicKey(PublicKey.from(proto.getPublicKey())).build();
    }

    public static Optional<TransparencyLog> find(List<TransparencyLog> all, byte[] logId) {
        return all.stream().filter(tl -> Arrays.equals(tl.getLogId().getKeyId(), logId)).findAny();
    }

    public static Optional<TransparencyLog> find(List<TransparencyLog> all, byte[] logId, Instant time) {
        return all.stream().filter(tl -> Arrays.equals(tl.getLogId().getKeyId(), logId)).filter(tl -> tl.getPublicKey().getValidFor().contains(time)).findAny();
    }
}

