/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import dev.sigstore.tuf.TufException;
import dev.sigstore.tuf.model.Signature;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class DuplicateKeyIdsException
extends TufException {
    private final List<Signature> signatures;
    private final String keyId;

    public DuplicateKeyIdsException(List<Signature> signatures, String keyId) {
        super(String.format(Locale.ROOT, "The role has multiple signatures with the same key_id. [Signatures: %s, KeyId: %s]", signatures.stream().map(Signature::getSignature).collect(Collectors.joining(",", "(", ")")), keyId));
        this.signatures = signatures;
        this.keyId = keyId;
    }

    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public String getKeyId() {
        return this.keyId;
    }
}

