/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ObjectParser;
import dev.sigstore.http.HttpClients;
import dev.sigstore.http.HttpParams;
import dev.sigstore.http.URIFormat;
import dev.sigstore.tuf.Fetcher;
import dev.sigstore.tuf.FileExceedsMaxLengthException;
import dev.sigstore.tuf.TufException;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;

public class HttpFetcher
implements Fetcher {
    private final URI mirror;
    private final HttpRequestFactory requestFactory;

    private HttpFetcher(URI mirror, HttpRequestFactory requestFactory) {
        this.mirror = mirror;
        this.requestFactory = requestFactory;
    }

    public static HttpFetcher newFetcher(URI mirror) throws IOException {
        HttpRequestFactory requestFactory = HttpClients.newRequestFactory(HttpParams.builder().build(), (ObjectParser)GsonFactory.getDefaultInstance().createJsonObjectParser());
        return new HttpFetcher(URIFormat.addTrailingSlash(mirror), requestFactory);
    }

    @Override
    public String getSource() {
        return this.mirror.toString();
    }

    @Override
    public byte[] fetchResource(String filename, int maxLength) throws IOException, FileExceedsMaxLengthException {
        GenericUrl fileUrl = new GenericUrl(URIFormat.appendPath(this.mirror, filename));
        HttpRequest req = this.requestFactory.buildGetRequest(fileUrl);
        req.getHeaders().setAccept("application/json; api-version=2.0");
        req.getHeaders().setContentType("application/json");
        req.setThrowExceptionOnExecuteError(false);
        HttpResponse resp = req.execute();
        if (resp.getStatusCode() == 404) {
            return null;
        }
        if (resp.getStatusCode() != 200) {
            throw new TufException(String.format(Locale.ROOT, "Unexpected return from mirror(%s). Status code: %s, status message: %s", this.mirror, resp.getStatusCode(), resp.getStatusMessage()));
        }
        byte[] roleBytes = resp.getContent().readNBytes(maxLength);
        if (roleBytes.length == maxLength && resp.getContent().read() != -1) {
            throw new FileExceedsMaxLengthException(fileUrl.toString(), maxLength);
        }
        return roleBytes;
    }
}

