/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import dev.sigstore.tuf.MetaReader;
import dev.sigstore.tuf.MetaStore;
import dev.sigstore.tuf.model.SignedTufMeta;
import dev.sigstore.tuf.model.TufMeta;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PassthroughCacheMetaStore
implements MetaReader,
MetaStore {
    private final MetaStore localStore;
    private final Map<String, SignedTufMeta<? extends TufMeta>> cache;

    private PassthroughCacheMetaStore(MetaStore localStore) {
        this.localStore = localStore;
        this.cache = new HashMap<String, SignedTufMeta<? extends TufMeta>>();
    }

    @Override
    public String getIdentifier() {
        return "In memory cache backed by: " + this.localStore.getIdentifier();
    }

    public static PassthroughCacheMetaStore newPassthroughMetaCache(MetaStore localStore) {
        return new PassthroughCacheMetaStore(localStore);
    }

    @Override
    public <T extends SignedTufMeta<? extends TufMeta>> Optional<T> readMeta(String roleName, Class<T> tClass) throws IOException {
        if (this.cache.containsKey(roleName)) {
            return Optional.of(this.cache.get(roleName));
        }
        Optional<SignedTufMeta> value = this.localStore.readMeta(roleName, tClass);
        value.ifPresent(v -> this.cache.put(roleName, (SignedTufMeta<? extends TufMeta>)v));
        return value;
    }

    @Override
    public void writeMeta(String roleName, SignedTufMeta<? extends TufMeta> meta) throws IOException {
        this.localStore.writeMeta(roleName, meta);
        this.cache.put(roleName, meta);
    }

    @Override
    public void clearMeta(String role) throws IOException {
        this.localStore.clearMeta(role);
        this.cache.remove(role);
    }
}

