/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import dev.sigstore.tuf.TufException;
import java.time.ZonedDateTime;
import java.util.Locale;

public class RoleExpiredException
extends TufException {
    private String mirrorUrl;
    private ZonedDateTime updateTime;
    private ZonedDateTime roleExpirationTime;

    public RoleExpiredException(String mirrorUrl, ZonedDateTime updateTime, ZonedDateTime roleExpirationTime) {
        super(String.format(Locale.ROOT, "Trusted metadata is expired but no new versions are available at the mirror URL:(%s)\n update start time: %tc\n expired time: %tc)", mirrorUrl, updateTime, roleExpirationTime));
        this.mirrorUrl = mirrorUrl;
        this.updateTime = updateTime;
        this.roleExpirationTime = roleExpirationTime;
    }

    public String getMirrorUrl() {
        return this.mirrorUrl;
    }

    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    public ZonedDateTime getRoleExpirationTime() {
        return this.roleExpirationTime;
    }
}

