/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import dev.sigstore.http.URIFormat;
import dev.sigstore.trustroot.SigstoreConfigurationException;
import dev.sigstore.trustroot.SigstoreSigningConfig;
import dev.sigstore.trustroot.SigstoreTrustedRoot;
import dev.sigstore.tuf.FileSystemTufStore;
import dev.sigstore.tuf.HttpFetcher;
import dev.sigstore.tuf.MetaFetcher;
import dev.sigstore.tuf.PassthroughCacheMetaStore;
import dev.sigstore.tuf.RootProvider;
import dev.sigstore.tuf.TrustedMetaStore;
import dev.sigstore.tuf.Updater;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.time.Duration;
import java.time.Instant;

public class SigstoreTufClient {
    @VisibleForTesting
    static final String TRUST_ROOT_FILENAME = "trusted_root.json";
    @VisibleForTesting
    static final String SIGNING_CONFIG_FILENAME = "signing_config.v0.2.json";
    public static final String PUBLIC_GOOD_ROOT_RESOURCE = "dev/sigstore/tuf/sigstore-tuf-root/root.json";
    public static final String STAGING_ROOT_RESOURCE = "dev/sigstore/tuf/tuf-root-staging/root.json";
    private final Updater updater;
    private Instant lastUpdate;
    private SigstoreTrustedRoot sigstoreTrustedRoot;
    private SigstoreSigningConfig sigstoreSigningConfig;
    private final Duration cacheValidity;

    @VisibleForTesting
    SigstoreTufClient(Updater updater, Duration cacheValidity) {
        this.updater = updater;
        this.cacheValidity = cacheValidity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void update() throws SigstoreConfigurationException {
        if (this.lastUpdate == null || Duration.between(this.lastUpdate, Instant.now()).compareTo(this.cacheValidity) > 0) {
            this.forceUpdate();
        }
    }

    public void forceUpdate() throws SigstoreConfigurationException {
        try {
            this.updater.update();
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new SigstoreConfigurationException("TUF repo failed to update", ex);
        }
        this.lastUpdate = Instant.now();
        try {
            this.sigstoreTrustedRoot = SigstoreTrustedRoot.from(this.updater.getTargetStore().getTargetInputSteam(TRUST_ROOT_FILENAME));
        }
        catch (IOException ex) {
            throw new SigstoreConfigurationException("Failed to read trusted root from target store", ex);
        }
        try {
            this.sigstoreSigningConfig = SigstoreSigningConfig.from(this.updater.getTargetStore().getTargetInputSteam(SIGNING_CONFIG_FILENAME));
        }
        catch (IOException ex) {
            throw new SigstoreConfigurationException("Failed to read signing config from target store", ex);
        }
    }

    public SigstoreTrustedRoot getSigstoreTrustedRoot() {
        return this.sigstoreTrustedRoot;
    }

    public SigstoreSigningConfig getSigstoreSigningConfig() {
        return this.sigstoreSigningConfig;
    }

    public static class Builder {
        Duration cacheValidity = Duration.ofDays(1L);
        Path tufCacheLocation = Path.of(System.getProperty("user.home"), new String[0]).resolve(".sigstore-java").resolve("root");
        private URI remoteMirror;
        private RootProvider trustedRoot;

        public Builder usePublicGoodInstance() {
            if (this.remoteMirror != null || this.trustedRoot != null) {
                throw new IllegalStateException("Using public good after configuring remoteMirror and trustedRoot");
            }
            this.tufMirror(URI.create("https://tuf-repo-cdn.sigstore.dev/"), RootProvider.fromResource(SigstoreTufClient.PUBLIC_GOOD_ROOT_RESOURCE));
            return this;
        }

        public Builder useStagingInstance() {
            if (this.remoteMirror != null || this.trustedRoot != null) {
                throw new IllegalStateException("Using staging after configuring remoteMirror and trustedRoot");
            }
            this.tufMirror(URI.create("https://tuf-repo-cdn.sigstage.dev"), RootProvider.fromResource(SigstoreTufClient.STAGING_ROOT_RESOURCE));
            this.tufCacheLocation = Path.of(System.getProperty("user.home"), new String[0]).resolve(".sigstore-java").resolve("staging").resolve("root");
            return this;
        }

        public Builder tufMirror(URI mirror, RootProvider trustedRoot) {
            this.remoteMirror = mirror;
            this.trustedRoot = trustedRoot;
            return this;
        }

        public Builder cacheValidity(Duration duration) {
            this.cacheValidity = duration;
            return this;
        }

        public Builder tufCacheLocation(Path location) {
            this.tufCacheLocation = location;
            return this;
        }

        public SigstoreTufClient build() throws IOException {
            Preconditions.checkState((!this.cacheValidity.isNegative() ? 1 : 0) != 0, (Object)"cacheValidity must be non negative");
            Preconditions.checkNotNull((Object)this.remoteMirror);
            Preconditions.checkNotNull((Object)this.trustedRoot);
            if (!Files.isDirectory(this.tufCacheLocation, new LinkOption[0])) {
                Files.createDirectories(this.tufCacheLocation, new FileAttribute[0]);
            }
            URI remoteTargetsLocation = URIFormat.appendPath(this.remoteMirror, "targets");
            FileSystemTufStore filesystemTufStore = FileSystemTufStore.newFileSystemStore(this.tufCacheLocation);
            Updater tufUpdater = Updater.builder().setTrustedRootPath(this.trustedRoot).setTrustedMetaStore(TrustedMetaStore.newTrustedMetaStore(PassthroughCacheMetaStore.newPassthroughMetaCache(filesystemTufStore))).setTargetStore(filesystemTufStore).setMetaFetcher(MetaFetcher.newFetcher(HttpFetcher.newFetcher(this.remoteMirror))).setTargetFetcher(HttpFetcher.newFetcher(remoteTargetsLocation)).build();
            return new SigstoreTufClient(tufUpdater, this.cacheValidity);
        }
    }
}

