/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Hashing;
import dev.sigstore.json.GsonSupplier;
import dev.sigstore.tuf.DuplicateKeyIdsException;
import dev.sigstore.tuf.Fetcher;
import dev.sigstore.tuf.FileExceedsMaxLengthException;
import dev.sigstore.tuf.FileNotFoundException;
import dev.sigstore.tuf.InvalidHashesException;
import dev.sigstore.tuf.MetaFetchResult;
import dev.sigstore.tuf.MetaFetcher;
import dev.sigstore.tuf.RoleExpiredException;
import dev.sigstore.tuf.RollbackVersionException;
import dev.sigstore.tuf.RootProvider;
import dev.sigstore.tuf.SignatureVerificationException;
import dev.sigstore.tuf.SnapshotTargetMissingException;
import dev.sigstore.tuf.SnapshotTargetVersionException;
import dev.sigstore.tuf.SnapshotVersionMismatchException;
import dev.sigstore.tuf.TargetMetadataMissingException;
import dev.sigstore.tuf.TargetStore;
import dev.sigstore.tuf.TrustedMetaStore;
import dev.sigstore.tuf.encryption.Verifiers;
import dev.sigstore.tuf.model.Hashes;
import dev.sigstore.tuf.model.Key;
import dev.sigstore.tuf.model.Role;
import dev.sigstore.tuf.model.Root;
import dev.sigstore.tuf.model.RootRole;
import dev.sigstore.tuf.model.Signature;
import dev.sigstore.tuf.model.SignedTufMeta;
import dev.sigstore.tuf.model.Snapshot;
import dev.sigstore.tuf.model.SnapshotMeta;
import dev.sigstore.tuf.model.TargetMeta;
import dev.sigstore.tuf.model.Targets;
import dev.sigstore.tuf.model.Timestamp;
import dev.sigstore.tuf.model.TufMeta;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

public class Updater {
    private static final int MAX_UPDATES = 1024;
    private static final Logger log = Logger.getLogger(Updater.class.getName());
    private final Clock clock;
    private final Verifiers.Supplier verifiers;
    private final MetaFetcher metaFetcher;
    private final Fetcher targetFetcher;
    private final RootProvider trustedRootPath;
    private final TrustedMetaStore trustedMetaStore;
    private final TargetStore targetStore;
    private ZonedDateTime updateStartTime;

    Updater(Clock clock, Verifiers.Supplier verifiers, MetaFetcher metaFetcher, Fetcher targetFetcher, RootProvider trustedRootPath, TrustedMetaStore trustedMetaStore, TargetStore targetStore) {
        this.clock = clock;
        this.verifiers = verifiers;
        this.trustedRootPath = trustedRootPath;
        this.metaFetcher = metaFetcher;
        this.targetFetcher = targetFetcher;
        this.trustedMetaStore = trustedMetaStore;
        this.targetStore = targetStore;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void update() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        this.updateMeta();
        this.downloadTargets(this.trustedMetaStore.getTargets());
    }

    public void updateMeta() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        this.updateRoot();
        Optional<Timestamp> oldTimestamp = this.trustedMetaStore.findTimestamp();
        this.updateTimestamp();
        if (!Objects.equals(oldTimestamp.orElse(null), this.trustedMetaStore.getTimestamp()) || this.trustedMetaStore.findSnapshot().isEmpty() || this.trustedMetaStore.findTargets().isEmpty()) {
            this.updateSnapshot();
            this.updateTargets();
        }
    }

    public void downloadTarget(String targetName) throws IOException {
        TargetMeta.TargetData targetData = this.trustedMetaStore.getTargets().getSignedMeta().getTargets().get(targetName);
        if (targetData == null) {
            throw new TargetMetadataMissingException(targetName);
        }
        if (this.targetStore.hasTarget(targetName)) {
            byte[] target = this.targetStore.readTarget(targetName);
            try {
                Updater.verifyHashes(targetName, target, targetData.getHashes());
                return;
            }
            catch (InvalidHashesException invalidHashesException) {
                // empty catch block
            }
        }
        this.downloadTarget(targetName, targetData);
    }

    void updateRoot() throws IOException, RoleExpiredException, FileExceedsMaxLengthException, RollbackVersionException, SignatureVerificationException {
        Optional<MetaFetchResult<Root>> newRootMaybe;
        Root trustedRoot;
        this.updateStartTime = ZonedDateTime.now(this.clock);
        Optional<Root> localRoot = this.trustedMetaStore.findRoot();
        if (localRoot.isPresent()) {
            trustedRoot = localRoot.get();
        } else {
            trustedRoot = (Root)GsonSupplier.GSON.get().fromJson(this.trustedRootPath.get(), Root.class);
            this.trustedMetaStore.setRoot(trustedRoot);
        }
        this.verifyDelegate(trustedRoot, trustedRoot);
        int baseVersion = trustedRoot.getSignedMeta().getVersion();
        RootRole preUpdateSnapshotRole = trustedRoot.getSignedMeta().getRoles().get("snapshot");
        RootRole preUpdateTimestampRole = trustedRoot.getSignedMeta().getRoles().get("timestamp");
        for (int nextVersion = baseVersion + 1; nextVersion < baseVersion + 1024 && !(newRootMaybe = this.metaFetcher.getRootAtVersion(nextVersion)).isEmpty(); ++nextVersion) {
            Root newRoot = newRootMaybe.get().getMetaResource();
            this.verifyDelegate(trustedRoot, newRoot);
            this.verifyDelegate(newRoot, newRoot);
            if (newRoot.getSignedMeta().getVersion() != nextVersion) {
                throw new RollbackVersionException(nextVersion, newRoot.getSignedMeta().getVersion());
            }
            trustedRoot = newRoot;
            this.trustedMetaStore.setRoot(trustedRoot);
        }
        ZonedDateTime expires = trustedRoot.getSignedMeta().getExpiresAsDate();
        this.throwIfExpired(expires);
        if (this.hasNewKeys(preUpdateSnapshotRole, trustedRoot.getSignedMeta().getRoles().get("snapshot")) || this.hasNewKeys(preUpdateTimestampRole, trustedRoot.getSignedMeta().getRoles().get("timestamp"))) {
            this.trustedMetaStore.clearMetaDueToKeyRotation();
        }
    }

    private void throwIfExpired(ZonedDateTime expires) {
        if (expires.isBefore(this.updateStartTime)) {
            throw new RoleExpiredException(this.metaFetcher.getSource(), this.updateStartTime, expires);
        }
    }

    private boolean hasNewKeys(RootRole oldRole, RootRole newRole) {
        return !newRole.getKeyids().stream().allMatch(key -> oldRole.getKeyids().contains(key));
    }

    void verifyDelegate(Root trustedRoot, SignedTufMeta<? extends TufMeta> delegate) throws SignatureVerificationException, IOException {
        this.verifyDelegate(delegate.getSignatures(), trustedRoot.getSignedMeta().getKeys(), trustedRoot.getSignedMeta().getRoles().get(delegate.getSignedMeta().getType()), delegate.getCanonicalSignedBytes());
    }

    @VisibleForTesting
    void verifyDelegate(List<Signature> signatures, Map<String, Key> publicKeys, Role role, byte[] verificationMaterial) throws IOException {
        HashSet<String> goodSigs = new HashSet<String>(role.getKeyids().size() * 4 / 3);
        for (String keyid : role.getKeyids()) {
            Signature signature;
            Key key;
            List<Signature> matchingSignatures = signatures.stream().filter(sig -> sig.getKeyId().equals(keyid)).collect(Collectors.toList());
            if (matchingSignatures.size() > 1) {
                throw new DuplicateKeyIdsException(matchingSignatures, keyid);
            }
            if (matchingSignatures.size() != 1 || (key = publicKeys.get((signature = matchingSignatures.get(0)).getKeyId())) == null) continue;
            try {
                byte[] signatureBytes = Hex.decode((String)signature.getSignature());
                if (this.verifiers.newVerifier(key).verify(verificationMaterial, signatureBytes)) {
                    goodSigs.add(signature.getKeyId());
                    continue;
                }
                log.log(Level.FINE, () -> String.format(Locale.ROOT, "TUF: ignored failed signature verification: '%s' for keyid: '%s'", signature.getSignature(), signature.getKeyId()));
            }
            catch (SignatureException e) {
                log.log(Level.FINE, () -> String.format(Locale.ROOT, "TUF: ignored unverifiable signature: '%s' for keyid: '%s', because '%s'", signature.getSignature(), signature.getKeyId(), e.getMessage()));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | DecoderException e) {
                log.log(Level.WARNING, e, () -> Updater.lambda$verifyDelegate$4(signature, keyid, (Exception)e));
            }
        }
        if (goodSigs.size() < role.getThreshold()) {
            throw new SignatureVerificationException(role.getThreshold(), goodSigs.size());
        }
    }

    void updateTimestamp() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, FileNotFoundException, SignatureVerificationException {
        Timestamp timestamp = this.metaFetcher.getMeta("timestamp", Timestamp.class).orElseThrow(() -> new FileNotFoundException("timestamp.json", this.metaFetcher.getSource())).getMetaResource();
        this.verifyDelegate(this.trustedMetaStore.getRoot(), timestamp);
        Optional<Timestamp> localTimestampMaybe = this.trustedMetaStore.findTimestamp();
        if (localTimestampMaybe.isPresent()) {
            Timestamp localTimestamp = localTimestampMaybe.get();
            if (localTimestamp.getSignedMeta().getVersion() > timestamp.getSignedMeta().getVersion()) {
                throw new RollbackVersionException(localTimestamp.getSignedMeta().getVersion(), timestamp.getSignedMeta().getVersion());
            }
            if (localTimestamp.getSignedMeta().getVersion() == timestamp.getSignedMeta().getVersion()) {
                return;
            }
        }
        this.throwIfExpired(timestamp.getSignedMeta().getExpiresAsDate());
        this.trustedMetaStore.setTimestamp(timestamp);
    }

    void updateSnapshot() throws IOException, FileNotFoundException, InvalidHashesException, SignatureVerificationException, NoSuchAlgorithmException, InvalidKeySpecException {
        int timestampSnapshotVersion = this.trustedMetaStore.getTimestamp().getSignedMeta().getSnapshotMeta().getVersion();
        Optional<MetaFetchResult<Snapshot>> snapshotResult = this.metaFetcher.getMeta("snapshot", timestampSnapshotVersion, Snapshot.class, this.trustedMetaStore.getTimestamp().getSignedMeta().getSnapshotMeta().getLengthOrDefault());
        if (snapshotResult.isEmpty()) {
            throw new FileNotFoundException(timestampSnapshotVersion + ".snapshot.json", this.metaFetcher.getSource());
        }
        MetaFetchResult<Snapshot> snapshot = snapshotResult.get();
        if (this.trustedMetaStore.getTimestamp().getSignedMeta().getSnapshotMeta().getHashes().isPresent()) {
            Updater.verifyHashes("snapshot", snapshot.getRawBytes(), this.trustedMetaStore.getTimestamp().getSignedMeta().getSnapshotMeta().getHashes().get());
        }
        this.verifyDelegate(this.trustedMetaStore.getRoot(), snapshot.getMetaResource());
        int snapshotVersion = snapshot.getMetaResource().getSignedMeta().getVersion();
        if (snapshotVersion != timestampSnapshotVersion) {
            throw new SnapshotVersionMismatchException(timestampSnapshotVersion, snapshotVersion);
        }
        Optional<Snapshot> trustedSnapshotMaybe = this.trustedMetaStore.findSnapshot();
        if (trustedSnapshotMaybe.isPresent()) {
            Snapshot trustedSnapshot = trustedSnapshotMaybe.get();
            for (Map.Entry<String, SnapshotMeta.SnapshotTarget> trustedTargetEntry : trustedSnapshot.getSignedMeta().getMeta().entrySet()) {
                SnapshotMeta.SnapshotTarget newTargetMeta = snapshot.getMetaResource().getSignedMeta().getMeta().get(trustedTargetEntry.getKey());
                if (newTargetMeta == null) {
                    throw new SnapshotTargetMissingException(trustedTargetEntry.getKey());
                }
                if (newTargetMeta.getVersion() >= trustedTargetEntry.getValue().getVersion()) continue;
                throw new SnapshotTargetVersionException(trustedTargetEntry.getKey(), newTargetMeta.getVersion(), trustedTargetEntry.getValue().getVersion());
            }
        }
        this.throwIfExpired(snapshot.getMetaResource().getSignedMeta().getExpiresAsDate());
        this.trustedMetaStore.setSnapshot(snapshot.getMetaResource());
    }

    @VisibleForTesting
    static void verifyHashes(String name, byte[] data, Hashes hashes) throws InvalidHashesException {
        ArrayList<InvalidHashesException.InvalidHash> badHashes = new ArrayList<InvalidHashesException.InvalidHash>(2);
        String expectedSha512 = hashes.getSha512();
        String expectedSha256 = hashes.getSha256();
        if (expectedSha256 == null && expectedSha512 == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "hashes parameter for %s must contain at least one of sha512 or sha256.", name));
        }
        String computedSha512 = Hashing.sha512().hashBytes(data).toString();
        if (expectedSha512 != null && !computedSha512.equals(expectedSha512)) {
            badHashes.add(new InvalidHashesException.InvalidHash("sha512", expectedSha512, computedSha512));
        }
        String computedSha256 = Hashing.sha256().hashBytes(data).toString();
        if (expectedSha256 != null && !computedSha256.equals(expectedSha256)) {
            badHashes.add(new InvalidHashesException.InvalidHash("sha256", expectedSha256, computedSha256));
        }
        if (!badHashes.isEmpty()) {
            throw new InvalidHashesException(name, (InvalidHashesException.InvalidHash[])badHashes.toArray(InvalidHashesException.InvalidHash[]::new));
        }
    }

    void updateTargets() throws IOException, FileNotFoundException, InvalidHashesException, SignatureVerificationException, NoSuchAlgorithmException, InvalidKeySpecException, FileExceedsMaxLengthException {
        SnapshotMeta.SnapshotTarget targetMeta = this.trustedMetaStore.getSnapshot().getSignedMeta().getTargetMeta("targets.json");
        Optional<MetaFetchResult<Targets>> targetsResultMaybe = this.metaFetcher.getMeta("targets", targetMeta.getVersion(), Targets.class, targetMeta.getLengthOrDefault());
        if (targetsResultMaybe.isEmpty()) {
            throw new FileNotFoundException(targetMeta.getVersion() + ".targets.json", this.metaFetcher.getSource());
        }
        MetaFetchResult<Targets> targetsResult = targetsResultMaybe.get();
        if (targetMeta.getHashes().isPresent()) {
            Updater.verifyHashes(targetMeta.getVersion() + ".targets.json", targetsResult.getRawBytes(), targetMeta.getHashes().get());
        }
        this.verifyDelegate(this.trustedMetaStore.getRoot(), targetsResult.getMetaResource());
        int targetsVersion = targetsResult.getMetaResource().getSignedMeta().getVersion();
        int snapshotTargetsVersion = targetMeta.getVersion();
        if (targetsVersion != snapshotTargetsVersion) {
            throw new SnapshotVersionMismatchException(snapshotTargetsVersion, targetsVersion);
        }
        this.throwIfExpired(targetsResult.getMetaResource().getSignedMeta().getExpiresAsDate());
        this.trustedMetaStore.setTargets(targetsResult.getMetaResource());
    }

    void downloadTargets(Targets targets) throws IOException, TargetMetadataMissingException, FileNotFoundException {
        for (Map.Entry<String, TargetMeta.TargetData> entry : targets.getSignedMeta().getTargets().entrySet()) {
            String targetName = entry.getKey();
            if (entry.getValue() == null) {
                throw new TargetMetadataMissingException(targetName);
            }
            TargetMeta.TargetData targetData = entry.getValue();
            this.downloadTarget(targetName, targetData);
        }
    }

    void downloadTarget(String targetName, TargetMeta.TargetData targetData) throws IOException {
        String versionedTargetName;
        byte[] targetBytes;
        String calculatedName = targetName;
        Object calculatedPath = "";
        if (targetName.contains("/")) {
            Path targetPath = Paths.get(targetName, new String[0]);
            calculatedName = targetPath.getFileName().toString();
            calculatedPath = targetPath.getParent().toString();
            if (!((String)calculatedPath).endsWith("/")) {
                calculatedPath = (String)calculatedPath + "/";
            }
        }
        if ((targetBytes = this.targetFetcher.fetchResource(versionedTargetName = targetData.getHashes().getSha512() != null ? (String)calculatedPath + targetData.getHashes().getSha512() + "." + calculatedName : (String)calculatedPath + targetData.getHashes().getSha256() + "." + calculatedName, targetData.getLength())) == null) {
            throw new FileNotFoundException(targetName, this.targetFetcher.getSource());
        }
        Updater.verifyHashes(targetName, targetBytes, targetData.getHashes());
        this.targetStore.writeTarget(targetName, targetBytes);
    }

    @VisibleForTesting
    TargetStore getTargetStore() {
        return this.targetStore;
    }

    @VisibleForTesting
    TrustedMetaStore getMetaStore() {
        return this.trustedMetaStore;
    }

    private static /* synthetic */ String lambda$verifyDelegate$4(Signature signature, String keyid, Exception e) {
        return String.format(Locale.ROOT, "TUF: ignored invalid signature: '%s' for keyid: '%s', because '%s'", signature.getSignature(), keyid, e.getMessage());
    }

    public static class Builder {
        private Clock clock = Clock.systemUTC();
        private Verifiers.Supplier verifiers = Verifiers::newVerifier;
        private MetaFetcher metaFetcher;
        private Fetcher targetFetcher;
        private RootProvider trustedRootPath;
        private TrustedMetaStore trustedMetaStore;
        private TargetStore targetStore;

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setVerifiers(Verifiers.Supplier verifiers) {
            this.verifiers = verifiers;
            return this;
        }

        public Builder setTrustedMetaStore(TrustedMetaStore trustedMetaStore) {
            this.trustedMetaStore = trustedMetaStore;
            return this;
        }

        public Builder setTargetStore(TargetStore targetStore) {
            this.targetStore = targetStore;
            return this;
        }

        public Builder setTrustedRootPath(RootProvider trustedRootPath) {
            this.trustedRootPath = trustedRootPath;
            return this;
        }

        public Builder setMetaFetcher(MetaFetcher metaFetcher) {
            this.metaFetcher = metaFetcher;
            return this;
        }

        public Builder setTargetFetcher(Fetcher fetcher) {
            this.targetFetcher = fetcher;
            return this;
        }

        public Updater build() {
            return new Updater(this.clock, this.verifiers, this.metaFetcher, this.targetFetcher, this.trustedRootPath, this.trustedMetaStore, this.targetStore);
        }
    }
}

