/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.encryption;

import dev.sigstore.tuf.encryption.Verifier;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

class EcdsaVerifier
implements Verifier {
    private final PublicKey publicKey;

    EcdsaVerifier(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public boolean verify(byte[] artifact, byte[] signature) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature verifier = Signature.getInstance("SHA256withECDSA");
        verifier.initVerify(this.publicKey);
        verifier.update(artifact);
        return verifier.verify(signature);
    }
}

