/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.encryption;

import dev.sigstore.tuf.encryption.Verifier;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

class RsaPssVerifier
implements Verifier {
    private final PublicKey publicKey;

    RsaPssVerifier(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public boolean verify(byte[] artifact, byte[] signature) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature verifier = Signature.getInstance("SHA256withRSAandMGF1");
        verifier.initVerify(this.publicKey);
        verifier.update(artifact);
        return verifier.verify(signature);
    }
}

