/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import dev.sigstore.tuf.model.Hashes;
import dev.sigstore.tuf.model.ImmutableHashes;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="dev.sigstore.tuf.model", generator="Gsons")
public final class GsonAdaptersHashes
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (HashesTypeAdapter.adapts(type)) {
            return new HashesTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersHashes(Hashes)";
    }

    @Generated(from="Hashes", generator="Gsons")
    private static class HashesTypeAdapter
    extends TypeAdapter<Hashes> {
        HashesTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return Hashes.class == type.getRawType() || ImmutableHashes.class == type.getRawType();
        }

        public void write(JsonWriter out, Hashes value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeHashes(out, value);
            }
        }

        public Hashes read(JsonReader in) throws IOException {
            return this.readHashes(in);
        }

        private void writeHashes(JsonWriter out, Hashes instance) throws IOException {
            out.beginObject();
            String sha256Value = instance.getSha256();
            if (sha256Value != null) {
                out.name("sha256");
                out.value(sha256Value);
            } else if (out.getSerializeNulls()) {
                out.name("sha256");
                out.nullValue();
            }
            String sha512Value = instance.getSha512();
            if (sha512Value != null) {
                out.name("sha512");
                out.value(sha512Value);
            } else if (out.getSerializeNulls()) {
                out.name("sha512");
                out.nullValue();
            }
            out.endObject();
        }

        private Hashes readHashes(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableHashes.Builder builder = ImmutableHashes.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableHashes.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 's': {
                    if ("sha256".equals(attributeName)) {
                        this.readInSha256(in, builder);
                        return;
                    }
                    if (!"sha512".equals(attributeName)) break;
                    this.readInSha512(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInSha256(JsonReader in, ImmutableHashes.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.sha256(in.nextString());
            }
        }

        private void readInSha512(JsonReader in, ImmutableHashes.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.sha512(in.nextString());
            }
        }
    }
}

