/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import dev.sigstore.tuf.model.Hashes;
import dev.sigstore.tuf.model.ImmutableSnapshotMeta;
import dev.sigstore.tuf.model.ImmutableSnapshotTarget;
import dev.sigstore.tuf.model.SnapshotMeta;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="dev.sigstore.tuf.model", generator="Gsons")
public final class GsonAdaptersSnapshotMeta
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (SnapshotMetaTypeAdapter.adapts(type)) {
            return new SnapshotMetaTypeAdapter(gson);
        }
        if (SnapshotTargetTypeAdapter.adapts(type)) {
            return new SnapshotTargetTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersSnapshotMeta(SnapshotMeta, SnapshotTarget)";
    }

    @Generated(from="SnapshotMeta", generator="Gsons")
    private static class SnapshotMetaTypeAdapter
    extends TypeAdapter<SnapshotMeta> {
        public final SnapshotMeta.SnapshotTarget metaSecondaryTypeSample = null;
        private final TypeAdapter<SnapshotMeta.SnapshotTarget> metaSecondaryTypeAdapter;

        SnapshotMetaTypeAdapter(Gson gson) {
            this.metaSecondaryTypeAdapter = gson.getAdapter(SnapshotMeta.SnapshotTarget.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return SnapshotMeta.class == type.getRawType() || ImmutableSnapshotMeta.class == type.getRawType();
        }

        public void write(JsonWriter out, SnapshotMeta value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeSnapshotMeta(out, value);
            }
        }

        public SnapshotMeta read(JsonReader in) throws IOException {
            return this.readSnapshotMeta(in);
        }

        private void writeSnapshotMeta(JsonWriter out, SnapshotMeta instance) throws IOException {
            out.beginObject();
            out.name("_type");
            out.value(instance.getType());
            out.name("expires");
            out.value(instance.getExpires());
            out.name("spec_version");
            out.value(instance.getSpecVersion());
            out.name("version");
            out.value((long)instance.getVersion());
            Map<String, SnapshotMeta.SnapshotTarget> metaMapping = instance.getMeta();
            out.name("meta");
            out.beginObject();
            for (Map.Entry<String, SnapshotMeta.SnapshotTarget> e : metaMapping.entrySet()) {
                String key = e.getKey();
                out.name(key);
                SnapshotMeta.SnapshotTarget value = e.getValue();
                this.metaSecondaryTypeAdapter.write(out, (Object)value);
            }
            out.endObject();
            out.endObject();
        }

        private SnapshotMeta readSnapshotMeta(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableSnapshotMeta.Builder builder = ImmutableSnapshotMeta.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableSnapshotMeta.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case '_': {
                    if (!"_type".equals(attributeName)) break;
                    this.readInType(in, builder);
                    return;
                }
                case 'e': {
                    if (!"expires".equals(attributeName)) break;
                    this.readInExpires(in, builder);
                    return;
                }
                case 's': {
                    if (!"spec_version".equals(attributeName)) break;
                    this.readInSpecVersion(in, builder);
                    return;
                }
                case 'v': {
                    if (!"version".equals(attributeName)) break;
                    this.readInVersion(in, builder);
                    return;
                }
                case 'm': {
                    if (!"meta".equals(attributeName)) break;
                    this.readInMeta(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInType(JsonReader in, ImmutableSnapshotMeta.Builder builder) throws IOException {
            builder.type(in.nextString());
        }

        private void readInExpires(JsonReader in, ImmutableSnapshotMeta.Builder builder) throws IOException {
            builder.expires(in.nextString());
        }

        private void readInSpecVersion(JsonReader in, ImmutableSnapshotMeta.Builder builder) throws IOException {
            builder.specVersion(in.nextString());
        }

        private void readInVersion(JsonReader in, ImmutableSnapshotMeta.Builder builder) throws IOException {
            builder.version(in.nextInt());
        }

        private void readInMeta(JsonReader in, ImmutableSnapshotMeta.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    SnapshotMeta.SnapshotTarget value = (SnapshotMeta.SnapshotTarget)this.metaSecondaryTypeAdapter.read(in);
                    builder.putMeta(key, value);
                }
                in.endObject();
            }
        }
    }

    @Generated(from="SnapshotMeta.SnapshotTarget", generator="Gsons")
    private static class SnapshotTargetTypeAdapter
    extends TypeAdapter<SnapshotMeta.SnapshotTarget> {
        public final Hashes hashesTypeSample = null;
        public final Integer lengthTypeSample = null;
        private final TypeAdapter<Hashes> hashesTypeAdapter;
        private final TypeAdapter<Integer> lengthTypeAdapter;

        SnapshotTargetTypeAdapter(Gson gson) {
            this.hashesTypeAdapter = gson.getAdapter(Hashes.class);
            this.lengthTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return SnapshotMeta.SnapshotTarget.class == type.getRawType() || ImmutableSnapshotTarget.class == type.getRawType();
        }

        public void write(JsonWriter out, SnapshotMeta.SnapshotTarget value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeSnapshotTarget(out, value);
            }
        }

        public SnapshotMeta.SnapshotTarget read(JsonReader in) throws IOException {
            return this.readSnapshotTarget(in);
        }

        private void writeSnapshotTarget(JsonWriter out, SnapshotMeta.SnapshotTarget instance) throws IOException {
            out.beginObject();
            Optional<Hashes> hashesOptional = instance.getHashes();
            if (hashesOptional.isPresent()) {
                out.name("hashes");
                Hashes hashesValue = hashesOptional.get();
                this.hashesTypeAdapter.write(out, (Object)hashesValue);
            } else if (out.getSerializeNulls()) {
                out.name("hashes");
                out.nullValue();
            }
            Optional<Integer> lengthOptional = instance.getLength();
            if (lengthOptional.isPresent()) {
                out.name("length");
                Integer lengthValue = lengthOptional.get();
                this.lengthTypeAdapter.write(out, (Object)lengthValue);
            } else if (out.getSerializeNulls()) {
                out.name("length");
                out.nullValue();
            }
            out.name("version");
            out.value((long)instance.getVersion());
            out.endObject();
        }

        private SnapshotMeta.SnapshotTarget readSnapshotTarget(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableSnapshotTarget.Builder builder = ImmutableSnapshotTarget.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableSnapshotTarget.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'h': {
                    if (!"hashes".equals(attributeName)) break;
                    this.readInHashes(in, builder);
                    return;
                }
                case 'l': {
                    if (!"length".equals(attributeName)) break;
                    this.readInLength(in, builder);
                    return;
                }
                case 'v': {
                    if (!"version".equals(attributeName)) break;
                    this.readInVersion(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInHashes(JsonReader in, ImmutableSnapshotTarget.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Hashes value = (Hashes)this.hashesTypeAdapter.read(in);
                builder.hashes(value);
            }
        }

        private void readInLength(JsonReader in, ImmutableSnapshotTarget.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Integer value = (Integer)this.lengthTypeAdapter.read(in);
                builder.length(value);
            }
        }

        private void readInVersion(JsonReader in, ImmutableSnapshotTarget.Builder builder) throws IOException {
            builder.version(in.nextInt());
        }
    }
}

