/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.tuf.model.Hashes;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Hashes", generator="Immutables")
@Immutable
public final class ImmutableHashes
implements Hashes {
    @Nullable
    private final String sha256;
    @Nullable
    private final String sha512;

    private ImmutableHashes(@Nullable String sha256, @Nullable String sha512) {
        this.sha256 = sha256;
        this.sha512 = sha512;
    }

    @Override
    @Nullable
    public String getSha256() {
        return this.sha256;
    }

    @Override
    @Nullable
    public String getSha512() {
        return this.sha512;
    }

    public final ImmutableHashes withSha256(@Nullable String value) {
        if (Objects.equals(this.sha256, value)) {
            return this;
        }
        return new ImmutableHashes(value, this.sha512);
    }

    public final ImmutableHashes withSha512(@Nullable String value) {
        if (Objects.equals(this.sha512, value)) {
            return this;
        }
        return new ImmutableHashes(this.sha256, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHashes && this.equalTo(0, (ImmutableHashes)another);
    }

    private boolean equalTo(int synthetic, ImmutableHashes another) {
        return Objects.equals(this.sha256, another.sha256) && Objects.equals(this.sha512, another.sha512);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sha256);
        h += (h << 5) + Objects.hashCode(this.sha512);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Hashes").omitNullValues().add("sha256", (Object)this.sha256).add("sha512", (Object)this.sha512).toString();
    }

    public static ImmutableHashes copyOf(Hashes instance) {
        if (instance instanceof ImmutableHashes) {
            return (ImmutableHashes)instance;
        }
        return ImmutableHashes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Hashes", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sha256;
        @Nullable
        private String sha512;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Hashes instance) {
            String sha512Value;
            Objects.requireNonNull(instance, "instance");
            String sha256Value = instance.getSha256();
            if (sha256Value != null) {
                this.sha256(sha256Value);
            }
            if ((sha512Value = instance.getSha512()) != null) {
                this.sha512(sha512Value);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sha256(@Nullable String sha256) {
            this.sha256 = sha256;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sha512(@Nullable String sha512) {
            this.sha512 = sha512;
            return this;
        }

        public ImmutableHashes build() {
            return new ImmutableHashes(this.sha256, this.sha512);
        }
    }
}

