/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.tuf.model.Signature;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Signature", generator="Immutables")
@Immutable
public final class ImmutableSignature
implements Signature {
    private final String keyId;
    private final String signature;

    private ImmutableSignature(String keyId, String signature) {
        this.keyId = keyId;
        this.signature = signature;
    }

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    public final ImmutableSignature withKeyId(String value) {
        String newValue = Objects.requireNonNull(value, "keyId");
        if (this.keyId.equals(newValue)) {
            return this;
        }
        return new ImmutableSignature(newValue, this.signature);
    }

    public final ImmutableSignature withSignature(String value) {
        String newValue = Objects.requireNonNull(value, "signature");
        if (this.signature.equals(newValue)) {
            return this;
        }
        return new ImmutableSignature(this.keyId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSignature && this.equalTo(0, (ImmutableSignature)another);
    }

    private boolean equalTo(int synthetic, ImmutableSignature another) {
        return this.keyId.equals(another.keyId) && this.signature.equals(another.signature);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.keyId.hashCode();
        h += (h << 5) + this.signature.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Signature").omitNullValues().add("keyId", (Object)this.keyId).add("signature", (Object)this.signature).toString();
    }

    public static ImmutableSignature copyOf(Signature instance) {
        if (instance instanceof ImmutableSignature) {
            return (ImmutableSignature)instance;
        }
        return ImmutableSignature.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Signature", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY_ID = 1L;
        private static final long INIT_BIT_SIGNATURE = 2L;
        private long initBits = 3L;
        @Nullable
        private String keyId;
        @Nullable
        private String signature;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Signature instance) {
            Objects.requireNonNull(instance, "instance");
            this.keyId(instance.getKeyId());
            this.signature(instance.getSignature());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyId(String keyId) {
            this.keyId = Objects.requireNonNull(keyId, "keyId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signature(String signature) {
            this.signature = Objects.requireNonNull(signature, "signature");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSignature build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSignature(this.keyId, this.signature);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("keyId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("signature");
            }
            return "Cannot build Signature, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

