/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.tuf.model.TargetMeta;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TargetMeta.SigstoreMeta", generator="Immutables")
@Immutable
public final class ImmutableSigstoreMeta
implements TargetMeta.SigstoreMeta {
    private final String status;
    @Nullable
    private final String uri;
    private final String usage;

    private ImmutableSigstoreMeta(String status, @Nullable String uri, String usage) {
        this.status = status;
        this.uri = uri;
        this.usage = usage;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public Optional<String> getUri() {
        return Optional.ofNullable(this.uri);
    }

    @Override
    public String getUsage() {
        return this.usage;
    }

    public final ImmutableSigstoreMeta withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals(newValue)) {
            return this;
        }
        return new ImmutableSigstoreMeta(newValue, this.uri, this.usage);
    }

    public final ImmutableSigstoreMeta withUri(String value) {
        String newValue = Objects.requireNonNull(value, "uri");
        if (Objects.equals(this.uri, newValue)) {
            return this;
        }
        return new ImmutableSigstoreMeta(this.status, newValue, this.usage);
    }

    public final ImmutableSigstoreMeta withUri(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.uri, value)) {
            return this;
        }
        return new ImmutableSigstoreMeta(this.status, value, this.usage);
    }

    public final ImmutableSigstoreMeta withUsage(String value) {
        String newValue = Objects.requireNonNull(value, "usage");
        if (this.usage.equals(newValue)) {
            return this;
        }
        return new ImmutableSigstoreMeta(this.status, this.uri, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSigstoreMeta && this.equalTo(0, (ImmutableSigstoreMeta)another);
    }

    private boolean equalTo(int synthetic, ImmutableSigstoreMeta another) {
        return this.status.equals(another.status) && Objects.equals(this.uri, another.uri) && this.usage.equals(another.usage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode(this.uri);
        h += (h << 5) + this.usage.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SigstoreMeta").omitNullValues().add("status", (Object)this.status).add("uri", (Object)this.uri).add("usage", (Object)this.usage).toString();
    }

    public static ImmutableSigstoreMeta copyOf(TargetMeta.SigstoreMeta instance) {
        if (instance instanceof ImmutableSigstoreMeta) {
            return (ImmutableSigstoreMeta)instance;
        }
        return ImmutableSigstoreMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TargetMeta.SigstoreMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STATUS = 1L;
        private static final long INIT_BIT_USAGE = 2L;
        private long initBits = 3L;
        @Nullable
        private String status;
        @Nullable
        private String uri;
        @Nullable
        private String usage;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TargetMeta.SigstoreMeta instance) {
            Objects.requireNonNull(instance, "instance");
            this.status(instance.getStatus());
            Optional<String> uriOptional = instance.getUri();
            if (uriOptional.isPresent()) {
                this.uri(uriOptional);
            }
            this.usage(instance.getUsage());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(String uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(Optional<String> uri) {
            this.uri = uri.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder usage(String usage) {
            this.usage = Objects.requireNonNull(usage, "usage");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSigstoreMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSigstoreMeta(this.status, this.uri, this.usage);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("usage");
            }
            return "Cannot build SigstoreMeta, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

