/*
 * Decompiled with CFR 0.152.
 */
package dev.sigstore.tuf.model;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.sigstore.tuf.model.Hashes;
import dev.sigstore.tuf.model.SnapshotMeta;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SnapshotMeta.SnapshotTarget", generator="Immutables")
@Immutable
public final class ImmutableSnapshotTarget
implements SnapshotMeta.SnapshotTarget {
    @Nullable
    private final Hashes hashes;
    @Nullable
    private final Integer length;
    private final transient Integer lengthOrDefault;
    private final int version;

    private ImmutableSnapshotTarget(@Nullable Hashes hashes, @Nullable Integer length, int version) {
        this.hashes = hashes;
        this.length = length;
        this.version = version;
        this.lengthOrDefault = Objects.requireNonNull(SnapshotMeta.SnapshotTarget.super.getLengthOrDefault(), "lengthOrDefault");
    }

    @Override
    public Optional<Hashes> getHashes() {
        return Optional.ofNullable(this.hashes);
    }

    @Override
    public Optional<Integer> getLength() {
        return Optional.ofNullable(this.length);
    }

    @Override
    public Integer getLengthOrDefault() {
        return this.lengthOrDefault;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public final ImmutableSnapshotTarget withHashes(Hashes value) {
        Hashes newValue = Objects.requireNonNull(value, "hashes");
        if (this.hashes == newValue) {
            return this;
        }
        return new ImmutableSnapshotTarget(newValue, this.length, this.version);
    }

    public final ImmutableSnapshotTarget withHashes(Optional<? extends Hashes> optional) {
        Hashes value = optional.orElse(null);
        if (this.hashes == value) {
            return this;
        }
        return new ImmutableSnapshotTarget(value, this.length, this.version);
    }

    public final ImmutableSnapshotTarget withLength(int value) {
        Integer newValue = value;
        if (Objects.equals(this.length, newValue)) {
            return this;
        }
        return new ImmutableSnapshotTarget(this.hashes, newValue, this.version);
    }

    public final ImmutableSnapshotTarget withLength(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.length, value)) {
            return this;
        }
        return new ImmutableSnapshotTarget(this.hashes, value, this.version);
    }

    public final ImmutableSnapshotTarget withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableSnapshotTarget(this.hashes, this.length, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSnapshotTarget && this.equalTo(0, (ImmutableSnapshotTarget)another);
    }

    private boolean equalTo(int synthetic, ImmutableSnapshotTarget another) {
        return Objects.equals(this.hashes, another.hashes) && Objects.equals(this.length, another.length) && this.lengthOrDefault.equals(another.lengthOrDefault) && this.version == another.version;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.hashes);
        h += (h << 5) + Objects.hashCode(this.length);
        h += (h << 5) + this.lengthOrDefault.hashCode();
        h += (h << 5) + this.version;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SnapshotTarget").omitNullValues().add("hashes", (Object)this.hashes).add("length", (Object)this.length).add("lengthOrDefault", (Object)this.lengthOrDefault).add("version", this.version).toString();
    }

    public static ImmutableSnapshotTarget copyOf(SnapshotMeta.SnapshotTarget instance) {
        if (instance instanceof ImmutableSnapshotTarget) {
            return (ImmutableSnapshotTarget)instance;
        }
        return ImmutableSnapshotTarget.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SnapshotMeta.SnapshotTarget", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private long initBits = 1L;
        @Nullable
        private Hashes hashes;
        @Nullable
        private Integer length;
        private int version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SnapshotMeta.SnapshotTarget instance) {
            Optional<Integer> lengthOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Hashes> hashesOptional = instance.getHashes();
            if (hashesOptional.isPresent()) {
                this.hashes(hashesOptional);
            }
            if ((lengthOptional = instance.getLength()).isPresent()) {
                this.length(lengthOptional);
            }
            this.version(instance.getVersion());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hashes(Hashes hashes) {
            this.hashes = Objects.requireNonNull(hashes, "hashes");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hashes(Optional<? extends Hashes> hashes) {
            this.hashes = hashes.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder length(int length) {
            this.length = length;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder length(Optional<Integer> length) {
            this.length = length.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSnapshotTarget build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSnapshotTarget(this.hashes, this.length, this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build SnapshotTarget, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

